/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.spark.tanukisoft.maven;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.smallmind.nutsnbolts.freemarker.ClassPathTemplateLoader;
import org.smallmind.nutsnbolts.io.PathUtility;
import org.smallmind.nutsnbolts.zip.CompressionType;
import org.smallmind.spark.tanukisoft.maven.Dependency;
import org.smallmind.spark.tanukisoft.maven.EnvironmentArgument;
import org.smallmind.spark.tanukisoft.maven.OSType;

@Mojo(name="generate-wrapper", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class GenerateWrapperMojo
extends AbstractMojo {
    private static final EnvironmentArgument[] NO_ENV_ARGS = new EnvironmentArgument[0];
    private static final String[] NO_SIMPLE_ARGS = new String[0];
    private static final String RESOURCE_BASE_PATH = GenerateWrapperMojo.class.getPackage().getName().replace('.', '/');
    @Parameter(readonly=true, property="project")
    private MavenProject project;
    @Parameter
    private String licenseFile;
    @Parameter
    private Dependency[] dependencies;
    @Parameter(required=true)
    private String operatingSystem;
    @Parameter(required=true)
    private String wrapperListener;
    @Parameter(defaultValue="application")
    private String applicationDir;
    @Parameter(property="project.artifactId")
    private String applicationName;
    @Parameter(property="project.name")
    private String applicationLongName;
    @Parameter(property="project.description")
    private String applicationDescription;
    @Parameter
    private String[] jvmArgs;
    @Parameter
    private String jvmInitMemoryMB;
    @Parameter
    private String jvmMaxMemoryMB;
    @Parameter
    private String runAs;
    @Parameter(defaultValue="0")
    private int waitAfterStartup;
    @Parameter(defaultValue="java")
    private String javaCommand;
    @Parameter
    private String[] appParameters;
    @Parameter
    private EnvironmentArgument[] envArgs;
    @Parameter
    private String[] serviceDependencies;
    @Parameter
    private String[] configurations;
    @Parameter
    private String[] toSourceFiles;
    @Parameter(defaultValue="false")
    private boolean useUpstart;
    @Parameter(defaultValue="false")
    private boolean useSystemD;
    @Parameter(defaultValue="zip")
    private String compression;
    @Parameter(defaultValue="true")
    private boolean createArtifact;
    @Parameter(defaultValue="true")
    private boolean includeVersion;
    @Parameter(defaultValue="true")
    private boolean compactClasspath;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (!this.skip) {
            CompressionType compressionType;
            OSType osType;
            try {
                osType = OSType.valueOf(this.operatingSystem.replace('-', '_').toUpperCase());
                if (this.verbose) {
                    this.getLog().info((CharSequence)String.format("Using os type(%s)...", osType.name()));
                }
            }
            catch (Exception exception) {
                throw new MojoExecutionException(String.format("Unknown operating system type(%s) - valid choices are %s", this.operatingSystem, Arrays.toString((Object[])OSType.values())), exception);
            }
            try {
                compressionType = CompressionType.valueOf((String)this.compression.replace('-', '_').toUpperCase());
                if (this.verbose) {
                    this.getLog().info((CharSequence)String.format("Using compression type(%s)...", compressionType.name()));
                }
            }
            catch (Exception exception) {
                throw new MojoExecutionException(String.format("Unknown compression type(%s) - valid choices are %s", this.compression, Arrays.toString(CompressionType.values())), exception);
            }
            Path binDirectory = Paths.get(this.project.getBuild().getDirectory(), this.applicationDir, this.constructArtifactName(this.includeVersion, false), "bin");
            this.createDirectory("bin", binDirectory);
            Path libDirectory = Paths.get(this.project.getBuild().getDirectory(), this.applicationDir, this.constructArtifactName(this.includeVersion, false), "lib");
            this.createDirectory("lib", libDirectory);
            Path confDirectory = Paths.get(this.project.getBuild().getDirectory(), this.applicationDir, this.constructArtifactName(this.includeVersion, false), "conf");
            this.createDirectory("conf", confDirectory);
            if (this.licenseFile != null) {
                try {
                    if (this.verbose) {
                        this.getLog().info((CharSequence)String.format("Copying license file(%s)...", this.licenseFile));
                    }
                    Path licensePath = Paths.get(this.licenseFile, new String[0]);
                    this.copyToDestination(licensePath, confDirectory, PathUtility.fileNameAsString((Path)licensePath.getFileName()));
                }
                catch (IOException ioException) {
                    throw new MojoExecutionException("Problem in copying your license file into the application conf directory", (Exception)ioException);
                }
            }
            if (this.configurations != null) {
                for (String configuration : this.configurations) {
                    try {
                        if (this.verbose) {
                            this.getLog().info((CharSequence)String.format("Copying configuration(%s)...", configuration));
                        }
                        Path configurationPath = Paths.get(configuration, new String[0]);
                        this.copyToDestination(configurationPath, confDirectory, PathUtility.fileNameAsString((Path)configurationPath));
                    }
                    catch (IOException ioException) {
                        throw new MojoExecutionException(String.format("Problem in copying the configuration(%s) into the application conf directory", configuration), (Exception)ioException);
                    }
                }
            }
            StringBuilder aggregateFilesToSource = new StringBuilder();
            if (this.toSourceFiles != null) {
                for (String toSourceFile : this.toSourceFiles) {
                    if (aggregateFilesToSource.length() > 0) {
                        aggregateFilesToSource.append(';');
                    }
                    aggregateFilesToSource.append(toSourceFile);
                }
            }
            HashMap<String, Object> freemarkerMap = new HashMap<String, Object>();
            freemarkerMap.put("applicationName", this.applicationName);
            freemarkerMap.put("applicationLongName", this.applicationLongName);
            freemarkerMap.put("applicationDescription", this.applicationDescription != null ? this.applicationDescription : String.format("%s generated project", GenerateWrapperMojo.class.getSimpleName()));
            freemarkerMap.put("javaCommand", this.javaCommand);
            freemarkerMap.put("wrapperListener", this.wrapperListener);
            freemarkerMap.put("jvmArgs", this.jvmArgs != null ? this.jvmArgs : NO_SIMPLE_ARGS);
            freemarkerMap.put("envArgs", this.envArgs != null ? this.envArgs : NO_ENV_ARGS);
            if (this.jvmInitMemoryMB != null && !this.jvmInitMemoryMB.isEmpty()) {
                freemarkerMap.put("jvmInitMemoryMB", this.jvmInitMemoryMB);
            }
            if (this.jvmMaxMemoryMB != null && !this.jvmMaxMemoryMB.isEmpty()) {
                freemarkerMap.put("jvmMaxMemoryMB", this.jvmMaxMemoryMB);
            }
            if (this.runAs != null && !this.runAs.isEmpty()) {
                freemarkerMap.put("runAs", this.runAs);
            }
            freemarkerMap.put("useUpstart", this.useUpstart);
            freemarkerMap.put("useSystemD", this.useSystemD);
            freemarkerMap.put("waitAfterStartup", String.valueOf(this.waitAfterStartup));
            if (this.appParameters == null) {
                freemarkerMap.put("appParameters", new String[]{this.wrapperListener});
            } else {
                String[] modifiedAppParameters = new String[this.appParameters.length + 1];
                modifiedAppParameters[0] = this.wrapperListener;
                System.arraycopy(this.appParameters, 0, modifiedAppParameters, 1, this.appParameters.length);
                freemarkerMap.put("appParameters", modifiedAppParameters);
            }
            freemarkerMap.put("serviceDependencies", this.serviceDependencies != null ? this.serviceDependencies : NO_SIMPLE_ARGS);
            LinkedList<String> classpathElementList = new LinkedList<String>();
            freemarkerMap.put("classpathElements", classpathElementList);
            if (this.compactClasspath) {
                classpathElementList.add("*");
            }
            freemarkerMap.put("filesToSource", aggregateFilesToSource.toString());
            List<Dependency> additionalDependencies = this.dependencies != null ? Arrays.asList(this.dependencies) : null;
            for (Artifact artifact : this.project.getArtifacts()) {
                if (!artifact.getArtifactHandler().isAddedToClasspath() || !"compile".equals(artifact.getScope()) && !"runtime".equals(artifact.getScope())) continue;
                try {
                    if (this.verbose) {
                        this.getLog().info((CharSequence)String.format("Copying dependency(%s)...", artifact.getFile().getName()));
                    }
                    if (additionalDependencies != null) {
                        Iterator<Dependency> additionalDependencyIter = additionalDependencies.iterator();
                        while (additionalDependencyIter.hasNext()) {
                            if (!additionalDependencyIter.next().matchesArtifact(artifact)) continue;
                            additionalDependencyIter.remove();
                        }
                    }
                    if (!this.compactClasspath) {
                        classpathElementList.add(artifact.getFile().getName());
                    }
                    this.copyToDestination(artifact.getFile(), libDirectory, artifact.getFile().getName());
                }
                catch (IOException ioException) {
                    throw new MojoExecutionException(String.format("Problem in copying a dependency(%s) into the application library", artifact), (Exception)ioException);
                }
            }
            if (additionalDependencies != null) {
                for (Dependency dependency : additionalDependencies) {
                    for (Artifact artifact : this.project.getArtifacts()) {
                        if (!"compile".equals(artifact.getScope()) && !"provided".equals(artifact.getScope()) && !"system".equals(artifact.getScope()) || !dependency.matchesArtifact(artifact)) continue;
                        try {
                            if (this.verbose) {
                                this.getLog().info((CharSequence)String.format("Copying additional dependency(%s)...", artifact.getFile().getName()));
                            }
                            if (!this.compactClasspath) {
                                classpathElementList.add(artifact.getFile().getName());
                            }
                            this.copyToDestination(artifact.getFile(), libDirectory, artifact.getFile().getName());
                        }
                        catch (IOException ioException) {
                            throw new MojoExecutionException(String.format("Problem in copying an additional dependency(%s) into the application library", artifact), (Exception)ioException);
                        }
                    }
                }
            }
            if (!this.project.getArtifact().getType().equals("jar")) {
                Path jarPath = this.constructCompressedArtifactPath(this.project.getBuild().getDirectory(), CompressionType.JAR, false);
                String jarFileName = PathUtility.fileNameAsString((Path)jarPath);
                try {
                    if (this.verbose) {
                        this.getLog().info((CharSequence)String.format("Creating and copying output jar(%s)...", jarFileName));
                    }
                    CompressionType.JAR.compress(Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]), jarPath);
                    if (!this.compactClasspath) {
                        classpathElementList.add(jarFileName);
                    }
                    this.copyToDestination(jarPath, libDirectory, jarFileName);
                }
                catch (IOException ioException) {
                    throw new MojoExecutionException(String.format("Problem in creating or copying the output jar(%s) into the application library", jarFileName), (Exception)ioException);
                }
            }
            try {
                if (this.verbose) {
                    this.getLog().info((CharSequence)String.format("Copying build artifact(%s)...", this.project.getArtifact().getFile().getName()));
                }
                if (!this.compactClasspath) {
                    classpathElementList.add(this.project.getArtifact().getFile().getName());
                }
                this.copyToDestination(this.project.getArtifact().getFile(), libDirectory, this.project.getArtifact().getFile().getName());
            }
            catch (IOException ioException) {
                throw new MojoExecutionException(String.format("Problem in copying the build artifact(%s) into the application library", this.project.getArtifact()), (Exception)ioException);
            }
            try {
                if (this.verbose) {
                    this.getLog().info((CharSequence)String.format("Copying wrapper library(%s)...", osType.getLibrary()));
                }
                this.copyToDestination(this.getResourceAsStream(this.getWrapperPath("lib", osType.getLibrary())), libDirectory, osType.getLibrary());
                this.copyToDestination(this.getResourceAsStream(this.getWrapperPath("lib", osType.getLibrary())), libDirectory, osType.getOsStyle().getLibrary());
            }
            catch (IOException ioException) {
                throw new MojoExecutionException(String.format("Problem in copying the wrapper library(%s) into the application library", osType.getLibrary()), (Exception)ioException);
            }
            try {
                if (this.verbose) {
                    this.getLog().info((CharSequence)String.format("Copying wrapper executable(%s)...", osType.getExecutable()));
                }
                this.copyToDestination(this.getResourceAsStream(this.getWrapperPath("bin", osType.getExecutable())), binDirectory, osType.getExecutable());
            }
            catch (IOException ioException) {
                throw new MojoExecutionException(String.format("Problem in copying the wrapper executable(%s) into the application binaries", osType.getExecutable()), (Exception)ioException);
            }
            try {
                if (this.verbose) {
                    this.getLog().info((CharSequence)"Copying wrapper scripts...");
                }
                switch (osType.getOsStyle()) {
                    case UNIX: {
                        this.processFreemarkerTemplate(this.getWrapperPath("bin", "freemarker.App.sh.in"), binDirectory, this.applicationName + ".sh", freemarkerMap);
                        break;
                    }
                    case WINDOWS: {
                        this.copyToDestination(this.getResourceAsStream(this.getWrapperPath("bin", "AppCommand.bat.in")), binDirectory, this.applicationName + ".bat");
                        this.copyToDestination(this.getResourceAsStream(this.getWrapperPath("bin", "InstallApp-NT.bat.in")), binDirectory, "Install" + this.applicationName + "-NT.bat");
                        this.copyToDestination(this.getResourceAsStream(this.getWrapperPath("bin", "UninstallApp-NT.bat.in")), binDirectory, "Uninstall" + this.applicationName + "-NT.bat");
                        break;
                    }
                    default: {
                        throw new MojoExecutionException(String.format("Unknown os style(%s)", osType.getOsStyle().name()));
                    }
                }
            }
            catch (IOException ioException) {
                throw new MojoExecutionException("Problem in copying the wrapper scripts into the application binaries", (Exception)ioException);
            }
            if (this.verbose) {
                this.getLog().info((CharSequence)"Processing the configuration template...");
            }
            this.processFreemarkerTemplate(this.getWrapperPath("conf", "freemarker.wrapper.conf.in"), confDirectory, "wrapper.conf", freemarkerMap);
            if (this.createArtifact) {
                Path compressedFile = this.constructCompressedArtifactPath(this.project.getBuild().getDirectory(), compressionType, true);
                try {
                    if (this.verbose) {
                        this.getLog().info((CharSequence)String.format("Creating aggregated %s(%s)...", compressionType.getExtension(), compressedFile.getFileName()));
                    }
                    compressionType.compress(Paths.get(this.project.getBuild().getDirectory(), this.applicationDir), compressedFile);
                }
                catch (IOException ioException) {
                    throw new MojoExecutionException(String.format("Problem in creating the aggregated %s(%s)", compressionType.getExtension(), compressedFile.getFileName()), (Exception)ioException);
                }
            }
        }
    }

    private String constructArtifactName(boolean includeVersion, boolean aggregateArtifact) {
        StringBuilder nameBuilder = new StringBuilder(this.applicationName);
        if (includeVersion) {
            nameBuilder.append('-').append(this.project.getVersion());
        }
        if (this.project.getArtifact().getClassifier() != null) {
            nameBuilder.append('-').append(this.project.getArtifact().getClassifier());
        }
        if (aggregateArtifact) {
            nameBuilder.append("-app");
        }
        return nameBuilder.toString();
    }

    private Path constructCompressedArtifactPath(String outputDir, CompressionType artifactCompressionType, boolean aggregateArtifact) {
        return Paths.get(outputDir, this.constructArtifactName(true, aggregateArtifact) + "." + artifactCompressionType.getExtension());
    }

    private void processFreemarkerTemplate(Path templatePath, Path outputPath, String destinationFileName, HashMap<String, Object> interpolationMap) throws MojoExecutionException {
        BufferedWriter freemarkerWriter;
        Template freemarkerTemplate;
        Configuration freemarkerConf = new Configuration();
        freemarkerConf.setTagSyntax(2);
        freemarkerConf.setTemplateLoader((TemplateLoader)new ClassPathTemplateLoader(GenerateWrapperMojo.class));
        try {
            freemarkerTemplate = freemarkerConf.getTemplate(PathUtility.asResourceString((Path)templatePath));
        }
        catch (IOException ioException) {
            throw new MojoExecutionException(String.format("Unable to load template(%s) for translation", destinationFileName), (Exception)ioException);
        }
        try {
            freemarkerWriter = Files.newBufferedWriter(outputPath.resolve(destinationFileName), new OpenOption[0]);
        }
        catch (IOException ioException) {
            throw new MojoExecutionException(String.format("Problem in creating a writer for the template(%s) file", destinationFileName), (Exception)ioException);
        }
        try {
            freemarkerTemplate.process(interpolationMap, (Writer)freemarkerWriter);
        }
        catch (Exception exception) {
            throw new MojoExecutionException(String.format("Problem in processing the template(%s)", destinationFileName), exception);
        }
        try {
            ((Writer)freemarkerWriter).close();
        }
        catch (IOException ioException) {
            throw new MojoExecutionException(String.format("Problem in closing the template(%s) writer", destinationFileName), (Exception)ioException);
        }
    }

    private void createDirectory(String dirType, Path dirPath) throws MojoExecutionException {
        try {
            Files.createDirectories(dirPath, new FileAttribute[0]);
        }
        catch (IOException ioException) {
            throw new MojoExecutionException(String.format("Unable to create the '%s' application directory(%s)", dirType, dirPath.toAbsolutePath()));
        }
    }

    private Path getWrapperPath(String dirType, String fileName) {
        return Paths.get(RESOURCE_BASE_PATH, dirType, fileName);
    }

    private InputStream getResourceAsStream(Path path) throws MojoExecutionException {
        InputStream inputStream = GenerateWrapperMojo.class.getClassLoader().getResourceAsStream(PathUtility.asResourceString((Path)path));
        if (inputStream == null) {
            throw new MojoExecutionException(String.format("Unable to find resource at the specified path(%s)", path));
        }
        return inputStream;
    }

    private void copyToDestination(Path sourcePath, Path destinationPath, String destinationFileName) throws IOException {
        long bytesTransferred;
        FileChannel readChannel = FileChannel.open(sourcePath, StandardOpenOption.READ);
        FileChannel writeChannel = FileChannel.open(destinationPath.resolve(destinationFileName), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        for (long currentPosition = 0L; currentPosition < readChannel.size() && (bytesTransferred = readChannel.transferTo(currentPosition, 8192L, writeChannel)) >= 0L; currentPosition += bytesTransferred) {
        }
        writeChannel.close();
        readChannel.close();
    }

    private void copyToDestination(File file, Path destinationPath, String destinationFileName) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.copyToDestination(inputStream, destinationPath, destinationFileName);
        }
    }

    private void copyToDestination(InputStream inputStream, Path destinationPath, String destinationFileName) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[8192];
        OutputStream outputStream = Files.newOutputStream(destinationPath.resolve(destinationFileName), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        while ((bytesRead = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.close();
        inputStream.close();
    }
}

