/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.aop;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.smallmind.web.jersey.aop.EntityTranslator;
import org.smallmind.web.jersey.aop.ResourceMethod;

@Provider
public class ResourceMethodContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final ConcurrentHashMap<Class<? extends XmlAdapter>, XmlAdapter> ADAPTER_MAP = new ConcurrentHashMap();
    @Context
    ResourceInfo resourceInfo;

    public void filter(ContainerRequestContext requestContext) {
        ResourceMethod resourceMethod = this.resourceInfo.getResourceMethod().getAnnotation(ResourceMethod.class);
        if (resourceMethod != null) {
            EntityTranslator.storeEntityType(resourceMethod.value());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        block12: {
            try {
                XmlJavaTypeAdapter xmlJavaTypeAdapter = this.resourceInfo.getResourceMethod().getAnnotation(XmlJavaTypeAdapter.class);
                if (xmlJavaTypeAdapter == null) break block12;
                Class xmlAdapterClass = xmlJavaTypeAdapter.value();
                XmlAdapter xmlAdapter = ADAPTER_MAP.get(xmlAdapterClass);
                if (xmlAdapter == null) {
                    ConcurrentHashMap<Class<? extends XmlAdapter>, XmlAdapter> concurrentHashMap = ADAPTER_MAP;
                    synchronized (concurrentHashMap) {
                        xmlAdapter = ADAPTER_MAP.get(xmlAdapterClass);
                        if (xmlAdapter == null) {
                            try {
                                xmlAdapter = (XmlAdapter)xmlAdapterClass.newInstance();
                                ADAPTER_MAP.put(xmlAdapterClass, xmlAdapter);
                            }
                            catch (IllegalAccessException | InstantiationException exception) {
                                throw new IOException(exception);
                            }
                        }
                    }
                }
                try {
                    responseContext.setEntity(xmlAdapter.marshal(responseContext.getEntity()));
                }
                catch (Exception exception) {
                    throw new IOException(exception);
                }
            }
            finally {
                EntityTranslator.clearEntity();
            }
        }
    }
}

