/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jersey.multipart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.smallmind.web.jersey.multipart.MultiPartFileException;

public class MultiPartFile {
    private InputStream inputStream;
    private String fileName;
    private String contentType;

    public MultiPartFile(String fileName, String contentType, InputStream inputStream) {
        this.fileName = fileName;
        this.contentType = contentType;
        this.inputStream = inputStream;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public byte[] readAllBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = this.inputStream.read(buffer)) >= 0) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            byteArrayOutputStream.close();
        }
        catch (IOException ioException) {
            throw new MultiPartFileException(ioException);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

