/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.json.query;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.smallmind.nutsnbolts.json.ZonedDateTimeXmlAdapter;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.nutsnbolts.time.TimeUtility;
import org.smallmind.web.json.query.ComponentHint;
import org.smallmind.web.json.query.ComponentType;
import org.smallmind.web.json.query.ElementType;
import org.smallmind.web.json.query.EnumHint;
import org.smallmind.web.json.query.Hint;
import org.smallmind.web.json.query.OperandType;
import org.smallmind.web.json.query.QueryProcessingException;
import org.smallmind.web.json.query.WhereOperand;
import org.smallmind.web.json.query.WhereOperandPolymorphicXmlAdapter;
import org.smallmind.web.json.scaffold.util.JsonCodec;

@XmlRootElement(name="array")
@XmlJavaTypeAdapter(value=WhereOperandPolymorphicXmlAdapter.class)
public class ArrayWhereOperand
extends WhereOperand<Object[]> {
    private static final ZonedDateTimeXmlAdapter ZONED_DATE_TIME_XML_ADAPTER = new ZonedDateTimeXmlAdapter();
    private ArrayNode value;
    private Hint hint;

    public ArrayWhereOperand() {
    }

    public ArrayWhereOperand(Hint hint, ArrayNode value) {
        this.hint = hint;
        this.value = value;
    }

    public ArrayWhereOperand(Object[] array) {
        Class<?> componentClass = array.getClass().getComponentType();
        if (Boolean.class.equals(componentClass)) {
            this.hint = new ComponentHint(ComponentType.BOOLEAN);
            this.value = (ArrayNode)JsonCodec.writeAsJsonNode((Object)array);
        } else if (Byte.class.equals(componentClass)) {
            this.hint = new ComponentHint(ComponentType.BYTE);
            this.value = (ArrayNode)JsonCodec.writeAsJsonNode((Object)array);
        } else if (Character.class.equals(componentClass)) {
            this.hint = new ComponentHint(ComponentType.CHARACTER);
            this.value = (ArrayNode)JsonCodec.writeAsJsonNode((Object)array);
        } else if (Date.class.equals(componentClass)) {
            this.hint = new ComponentHint(ComponentType.DATE);
            this.value = JsonNodeFactory.instance.arrayNode();
            for (Object obj : array) {
                this.value.add(ZONED_DATE_TIME_XML_ADAPTER.marshal(TimeUtility.fromDate((Date)((Date)obj))));
            }
        } else if (Double.class.equals(componentClass)) {
            this.hint = new ComponentHint(ComponentType.DOUBLE);
            this.value = (ArrayNode)JsonCodec.writeAsJsonNode((Object)array);
        } else if (Float.class.equals(componentClass)) {
            this.hint = new ComponentHint(ComponentType.FLOAT);
            this.value = (ArrayNode)JsonCodec.writeAsJsonNode((Object)array);
        } else if (Integer.class.equals(componentClass)) {
            this.hint = new ComponentHint(ComponentType.INTEGER);
            this.value = (ArrayNode)JsonCodec.writeAsJsonNode((Object)array);
        } else if (Long.class.equals(componentClass)) {
            this.hint = new ComponentHint(ComponentType.LONG);
            this.value = (ArrayNode)JsonCodec.writeAsJsonNode((Object)array);
        } else if (Short.class.equals(componentClass)) {
            this.hint = new ComponentHint(ComponentType.SHORT);
            this.value = (ArrayNode)JsonCodec.writeAsJsonNode((Object)array);
        } else if (String.class.equals(componentClass)) {
            this.hint = new ComponentHint(ComponentType.STRING);
            this.value = (ArrayNode)JsonCodec.writeAsJsonNode((Object)array);
        } else if (Enum.class.isAssignableFrom(componentClass)) {
            this.hint = new EnumHint(componentClass);
            this.value = JsonNodeFactory.instance.arrayNode();
            for (Object obj : array) {
                this.value.add(((Enum)obj).name());
            }
        } else {
            throw new QueryProcessingException("Unknown array type(%s)", componentClass.getName());
        }
    }

    public static ArrayWhereOperand instance(Object[] value) {
        return new ArrayWhereOperand(value);
    }

    @Override
    @XmlTransient
    public ElementType getElementType() {
        switch (this.hint.getHintType()) {
            case COMPONENT: {
                switch (((ComponentHint)this.hint).getType()) {
                    case BOOLEAN: {
                        return ElementType.BOOLEAN;
                    }
                    case BYTE: {
                        return ElementType.NUMBER;
                    }
                    case CHARACTER: {
                        return ElementType.STRING;
                    }
                    case DATE: {
                        return ElementType.DATE;
                    }
                    case DOUBLE: {
                        return ElementType.NUMBER;
                    }
                    case FLOAT: {
                        return ElementType.NUMBER;
                    }
                    case INTEGER: {
                        return ElementType.NUMBER;
                    }
                    case LONG: {
                        return ElementType.NUMBER;
                    }
                    case SHORT: {
                        return ElementType.NUMBER;
                    }
                    case STRING: {
                        return ElementType.STRING;
                    }
                }
                throw new UnknownSwitchCaseException(((ComponentHint)this.hint).getType().name(), new Object[0]);
            }
            case ENUM: {
                return ElementType.STRING;
            }
        }
        throw new UnknownSwitchCaseException(this.hint.getHintType().name(), new Object[0]);
    }

    @Override
    @XmlTransient
    public OperandType getOperandType() {
        return OperandType.ARRAY;
    }

    @Override
    @XmlTransient
    public Object[] get() {
        if (this.value == null) {
            return null;
        }
        switch (this.hint.getHintType()) {
            case COMPONENT: {
                switch (((ComponentHint)this.hint).getType()) {
                    case BOOLEAN: {
                        Object[] booleanArray = new Boolean[this.value.size()];
                        for (int index = 0; index < this.value.size(); ++index) {
                            booleanArray[index] = (Boolean)JsonCodec.convert((Object)this.value.get(index), Boolean.class);
                        }
                        return booleanArray;
                    }
                    case BYTE: {
                        Object[] byteArray = new Byte[this.value.size()];
                        for (int index = 0; index < this.value.size(); ++index) {
                            byteArray[index] = this.value.get(index) == null ? null : (Byte)JsonCodec.convert((Object)this.value.get(index), Byte.class);
                        }
                        return byteArray;
                    }
                    case CHARACTER: {
                        Object[] characterArray = new Character[this.value.size()];
                        for (int index = 0; index < this.value.size(); ++index) {
                            String string;
                            characterArray[index] = this.value.get(index) == null ? null : ((string = (String)JsonCodec.convert((Object)this.value.get(index), String.class)).length() == 0 ? null : Character.valueOf(string.charAt(0)));
                        }
                        return characterArray;
                    }
                    case DATE: {
                        Object[] dates = new Date[this.value.size()];
                        for (int index = 0; index < this.value.size(); ++index) {
                            dates[index] = this.value.get(index) == null ? null : Date.from(ZONED_DATE_TIME_XML_ADAPTER.unmarshal((String)JsonCodec.convert((Object)this.value.get(index), String.class)).toInstant());
                        }
                        return dates;
                    }
                    case DOUBLE: {
                        Object[] doubleArray = new Double[this.value.size()];
                        for (int index = 0; index < this.value.size(); ++index) {
                            doubleArray[index] = (Double)JsonCodec.convert((Object)this.value.get(index), Double.class);
                        }
                        return doubleArray;
                    }
                    case FLOAT: {
                        Object[] floatArray = new Float[this.value.size()];
                        for (int index = 0; index < this.value.size(); ++index) {
                            floatArray[index] = this.value.get(index) == null ? null : (Float)JsonCodec.convert((Object)this.value.get(index), Float.class);
                        }
                        return floatArray;
                    }
                    case INTEGER: {
                        Object[] integerArray = new Integer[this.value.size()];
                        for (int index = 0; index < this.value.size(); ++index) {
                            integerArray[index] = (Integer)JsonCodec.convert((Object)this.value.get(index), Integer.class);
                        }
                        return integerArray;
                    }
                    case LONG: {
                        Object[] longArray = new Long[this.value.size()];
                        for (int index = 0; index < this.value.size(); ++index) {
                            longArray[index] = this.value.get(index) == null ? null : (Long)JsonCodec.convert((Object)this.value.get(index), Long.class);
                        }
                        return longArray;
                    }
                    case SHORT: {
                        Object[] shortArray = new Short[this.value.size()];
                        for (int index = 0; index < this.value.size(); ++index) {
                            shortArray[index] = this.value.get(index) == null ? null : (Short)JsonCodec.convert((Object)this.value.get(index), Short.class);
                        }
                        return shortArray;
                    }
                    case STRING: {
                        Object[] stringArray = new String[this.value.size()];
                        for (int index = 0; index < this.value.size(); ++index) {
                            stringArray[index] = this.value.get(index) == null ? null : (String)JsonCodec.convert((Object)this.value.get(index), String.class);
                        }
                        return stringArray;
                    }
                }
                throw new UnknownSwitchCaseException(((ComponentHint)this.hint).getType().name(), new Object[0]);
            }
            case ENUM: {
                try {
                    Class<?> enumClass = Class.forName(((EnumHint)this.hint).getType());
                    Object[] enumArray = new Object[this.value.size()];
                    for (int index = 0; index < this.value.size(); ++index) {
                        enumArray[index] = this.value.get(index) == null ? null : Enum.valueOf(enumClass, (String)JsonCodec.convert((Object)this.value.get(index), String.class));
                    }
                    return enumArray;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new QueryProcessingException(classNotFoundException);
                }
            }
        }
        throw new UnknownSwitchCaseException(this.hint.getHintType().name(), new Object[0]);
    }

    @XmlElement(name="hint")
    public Hint getHint() {
        return this.hint;
    }

    public void setHint(Hint hint) {
        this.hint = hint;
    }

    @XmlElement(name="value", required=true)
    public ArrayNode getValue() {
        return this.value;
    }

    public void setValue(ArrayNode value) {
        this.value = value;
    }
}

