/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.json.query;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.smallmind.web.json.query.ElementType;
import org.smallmind.web.json.query.EnumHint;
import org.smallmind.web.json.query.OperandType;
import org.smallmind.web.json.query.QueryProcessingException;
import org.smallmind.web.json.query.WhereOperand;
import org.smallmind.web.json.query.WhereOperandPolymorphicXmlAdapter;

@XmlRootElement(name="enum")
@XmlJavaTypeAdapter(value=WhereOperandPolymorphicXmlAdapter.class)
public class EnumWhereOperand<E extends Enum<E>>
extends WhereOperand<E> {
    private EnumHint hint;
    private String value;

    public EnumWhereOperand() {
    }

    public EnumWhereOperand(E enumeration) {
        this.hint = new EnumHint(enumeration.getClass());
        this.value = ((Enum)enumeration).name();
    }

    public static <E extends Enum<E>> EnumWhereOperand instance(E enumeration) {
        return new EnumWhereOperand<E>(enumeration);
    }

    @Override
    @XmlTransient
    public ElementType getElementType() {
        return ElementType.STRING;
    }

    @Override
    @XmlTransient
    public OperandType getOperandType() {
        return OperandType.ENUM;
    }

    @Override
    @XmlTransient
    public E get() {
        try {
            return (E)Enum.valueOf(Class.forName(this.hint.getType()), this.value);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new QueryProcessingException(classNotFoundException);
        }
    }

    @XmlElement(name="hint", required=true)
    public EnumHint getHint() {
        return this.hint;
    }

    public void setHint(EnumHint hint) {
        this.hint = hint;
    }

    @XmlElement(name="value", required=true)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

