/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.json.query;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.smallmind.web.json.query.ConjunctionType;
import org.smallmind.web.json.query.CriterionType;
import org.smallmind.web.json.query.WhereCriterion;

public abstract class WhereConjunction
extends WhereCriterion {
    private List<WhereCriterion> criterionList;

    public WhereConjunction() {
    }

    public WhereConjunction(WhereCriterion ... criteria) {
        this.criterionList = new LinkedList<WhereCriterion>();
        for (WhereCriterion criterion : criteria) {
            if (criterion == null) continue;
            this.criterionList.add(criterion);
        }
    }

    public abstract ConjunctionType getConjunctionType();

    @Override
    @XmlTransient
    public CriterionType getCriterionType() {
        return CriterionType.CONJUNCTION;
    }

    @XmlTransient
    public synchronized boolean isEmpty() {
        return this.criterionList == null || this.criterionList.isEmpty();
    }

    @XmlElement(name="criteria")
    public synchronized WhereCriterion[] getCriteria() {
        WhereCriterion[] criteria = new WhereCriterion[this.criterionList == null ? 0 : this.criterionList.size()];
        if (this.criterionList != null) {
            this.criterionList.toArray(criteria);
        }
        return criteria;
    }

    public synchronized void setCriteria(WhereCriterion ... criteria) {
        this.criterionList = Arrays.asList(criteria);
    }

    public synchronized void addCriterion(WhereCriterion criterion) {
        if (this.criterionList == null) {
            this.criterionList = new LinkedList<WhereCriterion>();
        }
        this.criterionList.add(criterion);
    }
}

