/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.json.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.smallmind.web.json.query.ArrayWhereOperand;
import org.smallmind.web.json.query.BooleanWhereOperand;
import org.smallmind.web.json.query.ByteWhereOperand;
import org.smallmind.web.json.query.CharacterWhereOperand;
import org.smallmind.web.json.query.ComponentHint;
import org.smallmind.web.json.query.ComponentType;
import org.smallmind.web.json.query.DateWhereOperand;
import org.smallmind.web.json.query.DoubleWhereOperand;
import org.smallmind.web.json.query.ElementType;
import org.smallmind.web.json.query.EnumWhereOperand;
import org.smallmind.web.json.query.FloatWhereOperand;
import org.smallmind.web.json.query.IntegerWhereOperand;
import org.smallmind.web.json.query.LongWhereOperand;
import org.smallmind.web.json.query.NullWhereOperand;
import org.smallmind.web.json.query.OperandType;
import org.smallmind.web.json.query.QueryProcessingException;
import org.smallmind.web.json.query.ShortWhereOperand;
import org.smallmind.web.json.query.StringWhereOperand;
import org.smallmind.web.json.query.WhereOperandPolymorphicXmlAdapter;
import org.smallmind.web.json.scaffold.util.XmlPolymorphicSubClasses;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlJavaTypeAdapter(value=WhereOperandPolymorphicXmlAdapter.class)
@XmlPolymorphicSubClasses(value={ArrayWhereOperand.class, BooleanWhereOperand.class, ByteWhereOperand.class, CharacterWhereOperand.class, DateWhereOperand.class, DoubleWhereOperand.class, EnumWhereOperand.class, FloatWhereOperand.class, IntegerWhereOperand.class, LongWhereOperand.class, NullWhereOperand.class, ShortWhereOperand.class, StringWhereOperand.class})
public abstract class WhereOperand<I> {
    public static WhereOperand<?> fromJsonNode(JsonNode node) {
        switch (node.getNodeType()) {
            case BOOLEAN: {
                return new BooleanWhereOperand(node.booleanValue());
            }
            case NUMBER: {
                switch (node.numberType()) {
                    case DOUBLE: {
                        return new DoubleWhereOperand(node.doubleValue());
                    }
                    case FLOAT: {
                        return new FloatWhereOperand(Float.valueOf(node.floatValue()));
                    }
                    case INT: {
                        return new IntegerWhereOperand(node.intValue());
                    }
                    case LONG: {
                        return new LongWhereOperand(node.longValue());
                    }
                }
                throw new QueryProcessingException("Unable to convert json number type(%s) to operand", node.numberType().name());
            }
            case STRING: {
                return new StringWhereOperand(node.textValue());
            }
            case NULL: {
                return NullWhereOperand.instance();
            }
            case ARRAY: {
                if (node.size() == 0) {
                    throw new QueryProcessingException("Unable to convert an empty array", new Object[0]);
                }
                switch (node.get(0).getNodeType()) {
                    case BOOLEAN: {
                        return new ArrayWhereOperand(new ComponentHint(ComponentType.BOOLEAN), (ArrayNode)node);
                    }
                    case NUMBER: {
                        switch (node.numberType()) {
                            case DOUBLE: {
                                return new ArrayWhereOperand(new ComponentHint(ComponentType.DOUBLE), (ArrayNode)node);
                            }
                            case FLOAT: {
                                return new ArrayWhereOperand(new ComponentHint(ComponentType.FLOAT), (ArrayNode)node);
                            }
                            case INT: {
                                return new ArrayWhereOperand(new ComponentHint(ComponentType.INTEGER), (ArrayNode)node);
                            }
                            case LONG: {
                                return new ArrayWhereOperand(new ComponentHint(ComponentType.LONG), (ArrayNode)node);
                            }
                        }
                        throw new QueryProcessingException("Unable to convert json array of number type(%s) to operand", node.numberType().name());
                    }
                    case STRING: {
                        return new ArrayWhereOperand(new ComponentHint(ComponentType.STRING), (ArrayNode)node);
                    }
                }
                throw new QueryProcessingException("Unable to convert json array of type(%s) to operand", node.getNodeType().name());
            }
        }
        throw new QueryProcessingException("Unable to convert json node type(%s) to operand", node.getNodeType().name());
    }

    public abstract ElementType getElementType();

    public abstract OperandType getOperandType();

    public abstract I get();
}

