/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.json.query;

import java.rmi.activation.UnknownObjectException;
import java.util.Date;
import org.smallmind.nutsnbolts.util.NumberComparator;
import org.smallmind.web.json.query.ElementType;
import org.smallmind.web.json.query.OperandType;
import org.smallmind.web.json.query.QueryProcessingException;
import org.smallmind.web.json.query.WhereOperand;

public enum WhereOperator {
    LT{

        @Override
        public boolean isTrue(WhereOperand<?> op1, WhereOperand<?> op2) {
            if (!OperandType.ARRAY.equals((Object)op1.getOperandType()) && !OperandType.ARRAY.equals((Object)op2.getOperandType())) {
                if (ElementType.NUMBER.equals((Object)op1.getElementType()) && ElementType.NUMBER.equals((Object)op2.getElementType())) {
                    return NUMBER_COMPARATOR.compare((Number)op1.get(), (Number)op2.get()) < 0;
                }
                if (ElementType.DATE.equals((Object)op1.getElementType()) && ElementType.DATE.equals((Object)op2.getElementType())) {
                    return ((Date)op1.get()).before((Date)op2.get());
                }
            }
            throw new QueryProcessingException("The operator(%s) requires numeric or date inputs", this.name());
        }
    }
    ,
    LE{

        @Override
        public boolean isTrue(WhereOperand<?> op1, WhereOperand<?> op2) {
            if (!OperandType.ARRAY.equals((Object)op1.getOperandType()) && !OperandType.ARRAY.equals((Object)op2.getOperandType())) {
                if (ElementType.NUMBER.equals((Object)op1.getElementType()) && ElementType.NUMBER.equals((Object)op2.getElementType())) {
                    return NUMBER_COMPARATOR.compare((Number)op1.get(), (Number)op2.get()) <= 0;
                }
                if (ElementType.DATE.equals((Object)op1.getElementType()) && ElementType.DATE.equals((Object)op2.getElementType())) {
                    return op1.get().equals(op2.get()) || ((Date)op1.get()).before((Date)op2.get());
                }
            }
            throw new QueryProcessingException("The operator(%s) requires numeric or date inputs", this.name());
        }
    }
    ,
    EQ{

        @Override
        public boolean isTrue(WhereOperand<?> op1, WhereOperand<?> op2) {
            if (!OperandType.ARRAY.equals((Object)op1.getOperandType()) && !OperandType.ARRAY.equals((Object)op2.getOperandType())) {
                if (ElementType.NULL.equals((Object)op1.getElementType())) {
                    return ElementType.NULL.equals((Object)op2.getElementType());
                }
                if (ElementType.NULL.equals((Object)op2.getElementType())) {
                    return false;
                }
                if (op1.getElementType().equals((Object)op2.getElementType())) {
                    switch (op1.getElementType()) {
                        case BOOLEAN: {
                            return op1.get().equals(op2.get());
                        }
                        case NUMBER: {
                            return NUMBER_COMPARATOR.compare((Number)op1.get(), (Number)op2.get()) == 0;
                        }
                        case STRING: {
                            return op1.get().equals(op2.get());
                        }
                        case DATE: {
                            return op1.get().equals(op2.get());
                        }
                    }
                    throw new QueryProcessingException((Throwable)new UnknownObjectException(op1.getElementType().name()));
                }
            }
            throw new QueryProcessingException("The operator(%s) is undefined for the operand types(%s and %s)", this.name(), op1.getOperandType().name(), op2.getOperandType().name());
        }
    }
    ,
    NE{

        @Override
        public boolean isTrue(WhereOperand<?> op1, WhereOperand<?> op2) {
            if (!OperandType.ARRAY.equals((Object)op1.getOperandType()) && !OperandType.ARRAY.equals((Object)op2.getOperandType())) {
                if (ElementType.NULL.equals((Object)op1.getElementType())) {
                    return !ElementType.NULL.equals((Object)op2.getElementType());
                }
                if (ElementType.NULL.equals((Object)op2.getElementType())) {
                    return true;
                }
                if (op1.getElementType().equals((Object)op2.getElementType())) {
                    switch (op1.getElementType()) {
                        case BOOLEAN: {
                            return !op1.get().equals(op2.get());
                        }
                        case NUMBER: {
                            return NUMBER_COMPARATOR.compare((Number)op1.get(), (Number)op2.get()) != 0;
                        }
                        case STRING: {
                            return !op1.get().equals(op2.get());
                        }
                        case DATE: {
                            return !op1.get().equals(op2.get());
                        }
                    }
                    throw new QueryProcessingException((Throwable)new UnknownObjectException(op1.getElementType().name()));
                }
            }
            throw new QueryProcessingException("The operator(%s) is undefined for the operand types(%s and %s)", this.name(), op1.getOperandType().name(), op2.getOperandType().name());
        }
    }
    ,
    GE{

        @Override
        public boolean isTrue(WhereOperand<?> op1, WhereOperand<?> op2) {
            if (!OperandType.ARRAY.equals((Object)op1.getOperandType()) && !OperandType.ARRAY.equals((Object)op2.getOperandType())) {
                if (ElementType.NUMBER.equals((Object)op1.getElementType()) && ElementType.NUMBER.equals((Object)op2.getElementType())) {
                    return NUMBER_COMPARATOR.compare((Number)op1.get(), (Number)op2.get()) >= 0;
                }
                if (ElementType.DATE.equals((Object)op1.getElementType()) && ElementType.DATE.equals((Object)op2.getElementType())) {
                    return op1.get().equals(op2.get()) || ((Date)op1.get()).after((Date)op2.get());
                }
            }
            throw new QueryProcessingException("The operator(%s) requires numeric or date inputs", this.name());
        }
    }
    ,
    GT{

        @Override
        public boolean isTrue(WhereOperand<?> op1, WhereOperand<?> op2) {
            if (!OperandType.ARRAY.equals((Object)op1.getOperandType()) && !OperandType.ARRAY.equals((Object)op2.getOperandType())) {
                if (ElementType.NUMBER.equals((Object)op1.getElementType()) && ElementType.NUMBER.equals((Object)op2.getElementType())) {
                    return NUMBER_COMPARATOR.compare((Number)op1.get(), (Number)op2.get()) > 0;
                }
                if (ElementType.DATE.equals((Object)op1.getElementType()) && ElementType.DATE.equals((Object)op2.getElementType())) {
                    return ((Date)op1.get()).after((Date)op2.get());
                }
            }
            throw new QueryProcessingException("The operator(%s) requires numeric or date inputs", this.name());
        }
    }
    ,
    LIKE{

        @Override
        public boolean isTrue(WhereOperand<?> op1, WhereOperand<?> op2) {
            if (!OperandType.ARRAY.equals((Object)op1.getOperandType()) && !OperandType.ARRAY.equals((Object)op2.getOperandType()) && ElementType.STRING.equals((Object)op1.getElementType())) {
                if (ElementType.NULL.equals((Object)op2.getElementType())) {
                    return false;
                }
                if (ElementType.STRING.equals((Object)op2.getElementType())) {
                    switch (((String)op1.get()).length()) {
                        case 0: {
                            return op2.get().equals("");
                        }
                        case 1: {
                            return op1.get().equals("%") || op2.get().equals(op1.get());
                        }
                        case 2: {
                            return op1.get().equals("%%") || ((String)op1.get()).charAt(0) == '%' ? ((String)op2.get()).endsWith(((String)op1.get()).substring(1)) : (((String)op1.get()).charAt(1) == '%' ? ((String)op2.get()).startsWith(((String)op1.get()).substring(0, 1)) : op2.get().equals(op1.get()));
                        }
                    }
                    if (((String)op1.get()).substring(1, ((String)op1.get()).length() - 1).indexOf(37) >= 0) {
                        throw new QueryProcessingException("The operation(%s) allows wildcards('%') only at the  start or end of the operand", this.name());
                    }
                    if (((String)op1.get()).startsWith("%") && ((String)op1.get()).endsWith("%")) {
                        return ((String)op2.get()).contains(((String)op1.get()).substring(1, ((String)op1.get()).length() - 1));
                    }
                    if (((String)op1.get()).startsWith("%")) {
                        return ((String)op2.get()).endsWith(((String)op1.get()).substring(1));
                    }
                    if (((String)op1.get()).endsWith("%")) {
                        return ((String)op2.get()).startsWith(((String)op1.get()).substring(0, ((String)op1.get()).length() - 1));
                    }
                    return op2.get().equals(op1.get());
                }
            }
            throw new QueryProcessingException("The operator(%s) requires a string operand and a string or null input", this.name());
        }
    }
    ,
    UNLIKE{

        @Override
        public boolean isTrue(WhereOperand<?> op1, WhereOperand<?> op2) {
            return !LIKE.isTrue(op1, op2);
        }
    }
    ,
    IN{

        @Override
        public boolean isTrue(WhereOperand<?> op1, WhereOperand<?> op2) {
            if (OperandType.ARRAY.equals((Object)op1.getOperandType()) && !OperandType.ARRAY.equals((Object)op2.getOperandType()) && op1.getElementType().equals((Object)op2.getElementType())) {
                if (ElementType.NULL.equals((Object)op2.getElementType())) {
                    return true;
                }
                block6: for (Object element : (Object[])op1.get()) {
                    switch (op2.getElementType()) {
                        case BOOLEAN: {
                            if (!op2.get().equals(element)) continue block6;
                            return true;
                        }
                        case NUMBER: {
                            if (NUMBER_COMPARATOR.compare((Number)element, (Number)op2.get()) != 0) continue block6;
                            return true;
                        }
                        case STRING: {
                            if (!op2.get().equals(element)) continue block6;
                            return true;
                        }
                        case DATE: {
                            if (!op2.get().equals(element)) continue block6;
                            return true;
                        }
                        default: {
                            throw new QueryProcessingException((Throwable)new UnknownObjectException(op1.getElementType().name()));
                        }
                    }
                }
                return false;
            }
            throw new QueryProcessingException("The operator(%s) requires an array operand and a singular non-null input matching the component type", this.name());
        }
    };

    private static final NumberComparator NUMBER_COMPARATOR;

    public abstract boolean isTrue(WhereOperand<?> var1, WhereOperand<?> var2);

    static {
        NUMBER_COMPARATOR = new NumberComparator();
    }
}

