/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.json.query;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.smallmind.web.json.query.Allowed;
import org.smallmind.web.json.query.AllowedWherePermit;
import org.smallmind.web.json.query.DependentWherePermit;
import org.smallmind.web.json.query.RequiredWherePermit;
import org.smallmind.web.json.query.TargetWherePermit;
import org.smallmind.web.json.query.WhereConstraint;
import org.smallmind.web.json.query.WherePermissible;
import org.smallmind.web.json.query.WherePermit;
import org.smallmind.web.json.query.WhereValidationException;

public class WhereValidator
implements ConstraintValidator<WhereConstraint, WherePermissible> {
    private WhereConstraint constraintAnnotation;

    public void initialize(WhereConstraint constraintAnnotation) {
        this.constraintAnnotation = constraintAnnotation;
    }

    public boolean isValid(WherePermissible permissible, ConstraintValidatorContext context) {
        LinkedList<WherePermit> permitList = new LinkedList<WherePermit>();
        for (Allowed allowed : this.constraintAnnotation.allow()) {
            permitList.add(new AllowedWherePermit(allowed.entity(), allowed.field()));
        }
        for (Annotation annotation : this.constraintAnnotation.require()) {
            permitList.add(new RequiredWherePermit(annotation.entity(), annotation.field()));
        }
        for (Annotation annotation : this.constraintAnnotation.exclude()) {
            permitList.add(new AllowedWherePermit(annotation.entity(), annotation.field()));
        }
        for (Annotation annotation : this.constraintAnnotation.dependencies()) {
            permitList.add(new DependentWherePermit(annotation.entity(), annotation.field(), new TargetWherePermit(annotation.requirement().entity(), annotation.requirement().field())));
        }
        WherePermit[] wherePermits = new WherePermit[permitList.size()];
        permitList.toArray(wherePermits);
        try {
            permissible.validate(wherePermits);
            return true;
        }
        catch (WhereValidationException whereValidationException) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(whereValidationException.getMessage()).addConstraintViolation();
            return false;
        }
    }
}

