/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.json.query.hibernate;

import java.util.LinkedList;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.web.json.query.Sort;
import org.smallmind.web.json.query.SortField;
import org.smallmind.web.json.query.Where;
import org.smallmind.web.json.query.WhereConjunction;
import org.smallmind.web.json.query.WhereCriterion;
import org.smallmind.web.json.query.WhereField;
import org.smallmind.web.json.query.WhereFieldTransformer;

public class HibernateQueryUtility {
    public static DetachedCriteria apply(DetachedCriteria detachedCriteria, Where where) {
        return HibernateQueryUtility.apply(detachedCriteria, where, null);
    }

    public static DetachedCriteria apply(DetachedCriteria detachedCriteria, Where where, WhereFieldTransformer<Void, Void> fieldTransformer) {
        Criterion walkedCriterion;
        if (where != null && (walkedCriterion = HibernateQueryUtility.walkConjunction(where.getRootConjunction(), fieldTransformer)) != null) {
            return detachedCriteria.add(walkedCriterion);
        }
        return detachedCriteria;
    }

    public static Criteria apply(Criteria criteria, Where where) {
        return HibernateQueryUtility.apply(criteria, where, null);
    }

    public static Criteria apply(Criteria criteria, Where where, WhereFieldTransformer<Void, Void> fieldTransformer) {
        Criterion walkedCriterion;
        if (where != null && (walkedCriterion = HibernateQueryUtility.walkConjunction(where.getRootConjunction(), fieldTransformer)) != null) {
            return criteria.add(walkedCriterion);
        }
        return criteria;
    }

    private static Criterion walkConjunction(WhereConjunction whereConjunction, WhereFieldTransformer<Void, Void> fieldTransformer) {
        if (whereConjunction == null || whereConjunction.isEmpty()) {
            return null;
        }
        LinkedList<Criterion> criterionList = new LinkedList<Criterion>();
        block8: for (WhereCriterion whereCriterion : whereConjunction.getCriteria()) {
            switch (whereCriterion.getCriterionType()) {
                case CONJUNCTION: {
                    Criterion walkedCriterion = HibernateQueryUtility.walkConjunction((WhereConjunction)whereCriterion, fieldTransformer);
                    if (walkedCriterion == null) continue block8;
                    criterionList.add(walkedCriterion);
                    continue block8;
                }
                case FIELD: {
                    criterionList.add(HibernateQueryUtility.walkField((WhereField)whereCriterion, fieldTransformer));
                    continue block8;
                }
                default: {
                    throw new UnknownSwitchCaseException(whereCriterion.getCriterionType().name(), new Object[0]);
                }
            }
        }
        if (criterionList.isEmpty()) {
            return null;
        }
        Criterion[] criteria = new Criterion[criterionList.size()];
        criterionList.toArray(criteria);
        switch (whereConjunction.getConjunctionType()) {
            case AND: {
                return Restrictions.and((Criterion[])criteria);
            }
            case OR: {
                return Restrictions.or((Criterion[])criteria);
            }
        }
        throw new UnknownSwitchCaseException(whereConjunction.getConjunctionType().name(), new Object[0]);
    }

    private static Criterion walkField(WhereField whereField, WhereFieldTransformer<Void, Void> fieldTransformer) {
        String fieldName = fieldTransformer == null ? whereField.getName() : fieldTransformer.transform(whereField.getEntity(), whereField.getName()).getField();
        Object fieldValue = whereField.getOperand().get();
        switch (whereField.getOperator()) {
            case LT: {
                return Restrictions.lt((String)whereField.getName(), fieldValue);
            }
            case LE: {
                return Restrictions.le((String)fieldName, fieldValue);
            }
            case EQ: {
                Object equalValue = fieldValue;
                return equalValue == null ? Restrictions.isNull((String)fieldName) : Restrictions.eq((String)fieldName, equalValue);
            }
            case NE: {
                Object notEqualValue = fieldValue;
                return notEqualValue == null ? Restrictions.isNotNull((String)fieldName) : Restrictions.ne((String)fieldName, notEqualValue);
            }
            case GE: {
                return Restrictions.ge((String)fieldName, fieldValue);
            }
            case GT: {
                return Restrictions.gt((String)fieldName, fieldValue);
            }
            case LIKE: {
                return Restrictions.like((String)fieldName, fieldValue);
            }
            case UNLIKE: {
                return Restrictions.not((Criterion)Restrictions.like((String)fieldName, fieldValue));
            }
            case IN: {
                return Restrictions.in((String)fieldName, (Object[])((Object[])fieldValue));
            }
        }
        throw new UnknownSwitchCaseException(whereField.getOperator().name(), new Object[0]);
    }

    public static Criteria apply(Criteria criteria, Sort sort) {
        return HibernateQueryUtility.apply(criteria, sort, null);
    }

    public static Criteria apply(Criteria criteria, Sort sort, WhereFieldTransformer<Void, Void> fieldTransformer) {
        if (sort != null && !sort.isEmpty()) {
            block4: for (SortField sortField : sort.getFields()) {
                String fieldName = fieldTransformer == null ? sortField.getName() : fieldTransformer.transform(sortField.getEntity(), sortField.getName()).getField();
                switch (sortField.getDirection()) {
                    case ASC: {
                        criteria.addOrder(Order.asc((String)fieldName));
                        continue block4;
                    }
                    case DESC: {
                        criteria.addOrder(Order.desc((String)fieldName));
                        continue block4;
                    }
                    default: {
                        throw new UnknownSwitchCaseException(sortField.getDirection().name(), new Object[0]);
                    }
                }
            }
        }
        return criteria;
    }
}

