/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.json.query.jpa;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.web.json.query.NoneProduct;
import org.smallmind.web.json.query.OperandType;
import org.smallmind.web.json.query.Product;
import org.smallmind.web.json.query.SomeProduct;
import org.smallmind.web.json.query.Sort;
import org.smallmind.web.json.query.SortField;
import org.smallmind.web.json.query.Where;
import org.smallmind.web.json.query.WhereConjunction;
import org.smallmind.web.json.query.WhereCriterion;
import org.smallmind.web.json.query.WhereField;
import org.smallmind.web.json.query.WhereFieldTransformer;
import org.smallmind.web.json.query.WherePath;
import org.smallmind.web.json.query.jpa.JPAWherePath;

public class JPAQueryUtility {
    public static Product<Root<?>, Predicate> apply(CriteriaBuilder criteriaBuilder, Where where, WhereFieldTransformer<Root<?>, Path<?>> fieldTransformer) {
        if (where == null) {
            return NoneProduct.none();
        }
        HashSet rootSet = new HashSet();
        Predicate predicate = JPAQueryUtility.walkConjunction(criteriaBuilder, rootSet, where.getRootConjunction(), fieldTransformer);
        if (predicate == null) {
            return NoneProduct.none();
        }
        return new SomeProduct(rootSet, predicate);
    }

    private static Predicate walkConjunction(CriteriaBuilder criteriaBuilder, Set<Root<?>> rootSet, WhereConjunction whereConjunction, WhereFieldTransformer<Root<?>, Path<?>> fieldTransformer) {
        if (whereConjunction == null || whereConjunction.isEmpty()) {
            return null;
        }
        LinkedList<Predicate> predicateList = new LinkedList<Predicate>();
        block8: for (WhereCriterion whereCriterion : whereConjunction.getCriteria()) {
            switch (whereCriterion.getCriterionType()) {
                case CONJUNCTION: {
                    Predicate walkedPredicate = JPAQueryUtility.walkConjunction(criteriaBuilder, rootSet, (WhereConjunction)whereCriterion, fieldTransformer);
                    if (walkedPredicate == null) continue block8;
                    predicateList.add(walkedPredicate);
                    continue block8;
                }
                case FIELD: {
                    predicateList.add(JPAQueryUtility.walkField(criteriaBuilder, rootSet, (WhereField)whereCriterion, fieldTransformer));
                    continue block8;
                }
                default: {
                    throw new UnknownSwitchCaseException(whereCriterion.getCriterionType().name(), new Object[0]);
                }
            }
        }
        if (predicateList.isEmpty()) {
            return null;
        }
        Predicate[] predicates = new Predicate[predicateList.size()];
        predicateList.toArray(predicates);
        switch (whereConjunction.getConjunctionType()) {
            case AND: {
                return criteriaBuilder.and(predicates);
            }
            case OR: {
                return criteriaBuilder.or(predicates);
            }
        }
        throw new UnknownSwitchCaseException(whereConjunction.getConjunctionType().name(), new Object[0]);
    }

    private static Predicate walkField(CriteriaBuilder criteriaBuilder, Set<Root<?>> rootSet, WhereField whereField, WhereFieldTransformer<Root<?>, Path<?>> fieldTransformer) {
        Object fieldValue = whereField.getOperand().get();
        WherePath<Root<?>, Path<?>> wherePath = fieldTransformer.transform(whereField.getEntity(), whereField.getName());
        rootSet.add(((JPAWherePath)wherePath).getRoot());
        switch (whereField.getOperator()) {
            case LT: {
                return OperandType.DATE.equals((Object)whereField.getOperand().getOperandType()) ? criteriaBuilder.lessThan(wherePath.getPath(), (Comparable)((Date)fieldValue)) : criteriaBuilder.lt(wherePath.getPath(), (Number)fieldValue);
            }
            case LE: {
                return OperandType.DATE.equals((Object)whereField.getOperand().getOperandType()) ? criteriaBuilder.lessThanOrEqualTo(wherePath.getPath(), (Comparable)((Date)fieldValue)) : criteriaBuilder.le(wherePath.getPath(), (Number)fieldValue);
            }
            case EQ: {
                if (fieldValue == null) {
                    return criteriaBuilder.isNull((Expression)wherePath.getPath());
                }
                return criteriaBuilder.equal((Expression)wherePath.getPath(), fieldValue);
            }
            case NE: {
                if (fieldValue == null) {
                    return criteriaBuilder.isNotNull((Expression)wherePath.getPath());
                }
                return criteriaBuilder.notEqual((Expression)wherePath.getPath(), fieldValue);
            }
            case GE: {
                return OperandType.DATE.equals((Object)whereField.getOperand().getOperandType()) ? criteriaBuilder.greaterThanOrEqualTo(wherePath.getPath(), (Comparable)((Date)fieldValue)) : criteriaBuilder.ge(wherePath.getPath(), (Number)fieldValue);
            }
            case GT: {
                return OperandType.DATE.equals((Object)whereField.getOperand().getOperandType()) ? criteriaBuilder.greaterThan(wherePath.getPath(), (Comparable)((Date)fieldValue)) : criteriaBuilder.gt(wherePath.getPath(), (Number)fieldValue);
            }
            case LIKE: {
                return criteriaBuilder.like(wherePath.getPath(), (String)fieldValue);
            }
            case UNLIKE: {
                return criteriaBuilder.notLike(wherePath.getPath(), (String)fieldValue);
            }
            case IN: {
                return criteriaBuilder.in(wherePath.getPath()).in(new Object[]{fieldValue});
            }
        }
        throw new UnknownSwitchCaseException(whereField.getOperator().name(), new Object[0]);
    }

    public static Product<Root<?>, Order[]> apply(CriteriaBuilder criteriaBuilder, Sort sort, WhereFieldTransformer<Root<?>, Path<?>> fieldTransformer) {
        if (sort != null && !sort.isEmpty()) {
            HashSet rootSet = new HashSet();
            LinkedList<Order> orderList = new LinkedList<Order>();
            block4: for (SortField sortField : sort.getFields()) {
                WherePath<Root<?>, Path<?>> wherePath = fieldTransformer.transform(sortField.getEntity(), sortField.getName());
                rootSet.add(((JPAWherePath)wherePath).getRoot());
                switch (sortField.getDirection()) {
                    case ASC: {
                        orderList.add(criteriaBuilder.asc((Expression)wherePath.getPath()));
                        continue block4;
                    }
                    case DESC: {
                        orderList.add(criteriaBuilder.desc((Expression)wherePath.getPath()));
                        continue block4;
                    }
                    default: {
                        throw new UnknownSwitchCaseException(sortField.getDirection().name(), new Object[0]);
                    }
                }
            }
            Order[] orders = new Order[orderList.size()];
            orderList.toArray(orders);
            return new SomeProduct(rootSet, orders);
        }
        return NoneProduct.none();
    }
}

