/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.json.query.morphia;

import java.util.Arrays;
import java.util.LinkedList;
import org.mongodb.morphia.query.Criteria;
import org.mongodb.morphia.query.FieldEnd;
import org.mongodb.morphia.query.Query;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.web.json.query.QueryProcessingException;
import org.smallmind.web.json.query.Sort;
import org.smallmind.web.json.query.SortField;
import org.smallmind.web.json.query.Where;
import org.smallmind.web.json.query.WhereConjunction;
import org.smallmind.web.json.query.WhereCriterion;
import org.smallmind.web.json.query.WhereField;
import org.smallmind.web.json.query.WhereFieldTransformer;
import org.smallmind.web.json.query.WhereOperator;

public class MorphiaQueryUtility {
    public static <T> Query<T> apply(Query<T> query, Where where) {
        return MorphiaQueryUtility.apply(query, where, null);
    }

    public static <T> Query<T> apply(Query<T> query, Where where, WhereFieldTransformer<Void, Void> fieldTransformer) {
        if (where != null) {
            MorphiaQueryUtility.walkConjunction(query, where.getRootConjunction(), fieldTransformer);
        }
        return query;
    }

    private static <T> Criteria walkConjunction(Query<T> query, WhereConjunction whereConjunction, WhereFieldTransformer<Void, Void> fieldTransformer) {
        if (whereConjunction == null || whereConjunction.isEmpty()) {
            return null;
        }
        LinkedList<Criteria> criteriaList = new LinkedList<Criteria>();
        block8: for (WhereCriterion whereCriterion : whereConjunction.getCriteria()) {
            switch (whereCriterion.getCriterionType()) {
                case CONJUNCTION: {
                    Criteria criteria = MorphiaQueryUtility.walkConjunction(query, (WhereConjunction)whereCriterion, fieldTransformer);
                    if (criteria == null) continue block8;
                    criteriaList.add(criteria);
                    continue block8;
                }
                case FIELD: {
                    Criteria criteria = MorphiaQueryUtility.walkField(query, (WhereField)whereCriterion, fieldTransformer);
                    if (criteria == null) continue block8;
                    criteriaList.add(criteria);
                    continue block8;
                }
                default: {
                    throw new UnknownSwitchCaseException(whereCriterion.getCriterionType().name(), new Object[0]);
                }
            }
        }
        if (criteriaList.isEmpty()) {
            return null;
        }
        Criteria[] criteria = new Criteria[criteriaList.size()];
        criteriaList.toArray(criteria);
        switch (whereConjunction.getConjunctionType()) {
            case AND: {
                return query.and(criteria);
            }
            case OR: {
                return query.or(criteria);
            }
        }
        throw new UnknownSwitchCaseException(whereConjunction.getConjunctionType().name(), new Object[0]);
    }

    private static <T> Criteria walkField(Query<T> query, WhereField whereField, WhereFieldTransformer<Void, Void> fieldTransformer) {
        FieldEnd fieldEnd = query.criteria(fieldTransformer == null ? whereField.getName() : fieldTransformer.transform(whereField.getEntity(), whereField.getName()).getField());
        Object fieldValue = whereField.getOperand().get();
        switch (whereField.getOperator()) {
            case LT: {
                return (Criteria)fieldEnd.lessThan(fieldValue);
            }
            case LE: {
                return (Criteria)fieldEnd.lessThanOrEq(fieldValue);
            }
            case EQ: {
                Object equalValue = fieldValue;
                return equalValue == null ? (Criteria)fieldEnd.doesNotExist() : (Criteria)fieldEnd.equal(equalValue);
            }
            case NE: {
                Object notEqualValue = fieldValue;
                return notEqualValue == null ? (Criteria)fieldEnd.exists() : (Criteria)fieldEnd.notEqual(notEqualValue);
            }
            case GE: {
                return (Criteria)fieldEnd.greaterThanOrEq(fieldValue);
            }
            case GT: {
                return (Criteria)fieldEnd.greaterThan(fieldValue);
            }
            case LIKE: {
                Object likeValue = fieldValue;
                if (likeValue == null) {
                    return (Criteria)fieldEnd.doesNotExist();
                }
                if (!(likeValue instanceof String)) {
                    throw new QueryProcessingException("The operation(%s) requires a String operand", WhereOperator.LIKE.name());
                }
                switch (((String)likeValue).length()) {
                    case 0: {
                        return (Criteria)fieldEnd.equal((Object)"");
                    }
                    case 1: {
                        return likeValue.equals("%") ? (Criteria)fieldEnd.exists() : (Criteria)fieldEnd.equal(likeValue);
                    }
                    case 2: {
                        return likeValue.equals("%%") ? (Criteria)fieldEnd.exists() : (((String)likeValue).charAt(0) == '%' ? (Criteria)fieldEnd.endsWith(((String)likeValue).substring(1)) : (((String)likeValue).charAt(1) == '%' ? (Criteria)fieldEnd.startsWith(((String)likeValue).substring(0, 1)) : (Criteria)fieldEnd.equal(likeValue)));
                    }
                }
                if (((String)likeValue).substring(1, ((String)likeValue).length() - 1).indexOf(37) >= 0) {
                    throw new QueryProcessingException("The operation(%s) allows wildcards('%') only at the  start or end of the operand", WhereOperator.LIKE.name());
                }
                if (((String)likeValue).startsWith("%") && ((String)likeValue).endsWith("%")) {
                    return (Criteria)fieldEnd.contains(((String)likeValue).substring(1, ((String)likeValue).length() - 1));
                }
                if (((String)likeValue).startsWith("%")) {
                    return (Criteria)fieldEnd.endsWith(((String)likeValue).substring(1));
                }
                if (((String)likeValue).endsWith("%")) {
                    return (Criteria)fieldEnd.startsWith(((String)likeValue).substring(0, ((String)likeValue).length() - 1));
                }
                return (Criteria)fieldEnd.equal(likeValue);
            }
            case UNLIKE: {
                Object unlikeValue = fieldValue;
                if (unlikeValue == null) {
                    return (Criteria)fieldEnd.exists();
                }
                if (!(unlikeValue instanceof String)) {
                    throw new QueryProcessingException("The operation(%s) requires a String operand", WhereOperator.UNLIKE.name());
                }
                switch (((String)unlikeValue).length()) {
                    case 0: {
                        return (Criteria)fieldEnd.notEqual((Object)"");
                    }
                    case 1: {
                        return unlikeValue.equals("%") ? (Criteria)fieldEnd.doesNotExist() : (Criteria)fieldEnd.notEqual(unlikeValue);
                    }
                    case 2: {
                        return unlikeValue.equals("%%") ? (Criteria)fieldEnd.doesNotExist() : (((String)unlikeValue).charAt(0) == '%' ? (Criteria)fieldEnd.not().endsWith(((String)unlikeValue).substring(1)) : (((String)unlikeValue).charAt(1) == '%' ? (Criteria)fieldEnd.not().startsWith(((String)unlikeValue).substring(0, 1)) : (Criteria)fieldEnd.notEqual(unlikeValue)));
                    }
                }
                if (((String)unlikeValue).substring(1, ((String)unlikeValue).length() - 1).indexOf(37) >= 0) {
                    throw new QueryProcessingException("The operation(%s) allows wildcards('%') only at the  start or end of the operand", WhereOperator.UNLIKE.name());
                }
                if (((String)unlikeValue).startsWith("%") && ((String)unlikeValue).endsWith("%")) {
                    return (Criteria)fieldEnd.not().contains(((String)unlikeValue).substring(1, ((String)unlikeValue).length() - 1));
                }
                if (((String)unlikeValue).startsWith("%")) {
                    return (Criteria)fieldEnd.not().endsWith(((String)unlikeValue).substring(1));
                }
                if (((String)unlikeValue).endsWith("%")) {
                    return (Criteria)fieldEnd.not().startsWith(((String)unlikeValue).substring(0, ((String)unlikeValue).length() - 1));
                }
                return (Criteria)fieldEnd.notEqual(unlikeValue);
            }
            case IN: {
                return (Criteria)fieldEnd.in(Arrays.asList((Object[])fieldValue));
            }
        }
        throw new UnknownSwitchCaseException(whereField.getOperator().name(), new Object[0]);
    }

    public static <T> Query<T> apply(Query<T> query, Sort sort) {
        return MorphiaQueryUtility.apply(query, sort, null);
    }

    public static <T> Query<T> apply(Query<T> query, Sort sort, WhereFieldTransformer<Void, Void> fieldTransformer) {
        if (sort != null && !sort.isEmpty()) {
            StringBuilder sortBuilder = new StringBuilder();
            block4: for (SortField sortField : sort.getFields()) {
                String fieldName;
                String string = fieldName = fieldTransformer == null ? sortField.getName() : fieldTransformer.transform(sortField.getEntity(), sortField.getName()).getField();
                if (sortBuilder.length() > 0) {
                    sortBuilder.append(", ");
                }
                switch (sortField.getDirection()) {
                    case ASC: {
                        sortBuilder.append(fieldName);
                        continue block4;
                    }
                    case DESC: {
                        sortBuilder.append('-').append(fieldName);
                        continue block4;
                    }
                    default: {
                        throw new UnknownSwitchCaseException(sortField.getDirection().name(), new Object[0]);
                    }
                }
            }
            return query.order(sortBuilder.toString());
        }
        return query;
    }
}

