/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.json.query.querydsl;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.web.json.query.NoneProduct;
import org.smallmind.web.json.query.Product;
import org.smallmind.web.json.query.SomeProduct;
import org.smallmind.web.json.query.Sort;
import org.smallmind.web.json.query.SortField;
import org.smallmind.web.json.query.Where;
import org.smallmind.web.json.query.WhereConjunction;
import org.smallmind.web.json.query.WhereCriterion;
import org.smallmind.web.json.query.WhereField;
import org.smallmind.web.json.query.WhereFieldTransformer;
import org.smallmind.web.json.query.WherePath;

public class QueryUtility {
    public static Product<Path<?>, Predicate> apply(Where where, WhereFieldTransformer<Path<?>, Path<?>> fieldTransformer) {
        if (where == null) {
            return NoneProduct.none();
        }
        HashSet rootSet = new HashSet();
        Predicate predicate = QueryUtility.walkConjunction(rootSet, where.getRootConjunction(), fieldTransformer);
        if (predicate == null) {
            return NoneProduct.none();
        }
        return new SomeProduct(rootSet, predicate);
    }

    private static Predicate walkConjunction(Set<Path<?>> rootSet, WhereConjunction whereConjunction, WhereFieldTransformer<Path<?>, Path<?>> fieldTransformer) {
        if (whereConjunction == null || whereConjunction.isEmpty()) {
            return null;
        }
        LinkedList<Predicate> predicateList = new LinkedList<Predicate>();
        block8: for (WhereCriterion whereCriterion : whereConjunction.getCriteria()) {
            switch (whereCriterion.getCriterionType()) {
                case CONJUNCTION: {
                    Predicate walkedPredicate = QueryUtility.walkConjunction(rootSet, (WhereConjunction)whereCriterion, fieldTransformer);
                    if (walkedPredicate == null) continue block8;
                    predicateList.add(walkedPredicate);
                    continue block8;
                }
                case FIELD: {
                    Predicate walkedPredicate = QueryUtility.walkField(rootSet, (WhereField)whereCriterion, fieldTransformer);
                    if (walkedPredicate == null) continue block8;
                    predicateList.add(walkedPredicate);
                    continue block8;
                }
                default: {
                    throw new UnknownSwitchCaseException(whereCriterion.getCriterionType().name(), new Object[0]);
                }
            }
        }
        if (predicateList.isEmpty()) {
            return null;
        }
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        switch (whereConjunction.getConjunctionType()) {
            case AND: {
                for (Predicate predicate : predicateList) {
                    booleanBuilder.and(predicate);
                }
                return booleanBuilder;
            }
            case OR: {
                for (Predicate predicate : predicateList) {
                    booleanBuilder.or(predicate);
                }
                return booleanBuilder;
            }
        }
        throw new UnknownSwitchCaseException(whereConjunction.getConjunctionType().name(), new Object[0]);
    }

    private static Predicate walkField(Set<Path<?>> rootSet, WhereField whereField, WhereFieldTransformer<Path<?>, Path<?>> fieldTransformer) {
        Object fieldValue = whereField.getOperand().get();
        WherePath<Path<?>, Path<?>> wherePath = fieldTransformer.transform(whereField.getEntity(), whereField.getName());
        rootSet.add(wherePath.getRoot());
        switch (whereField.getOperator()) {
            case LT: {
                return Expressions.predicate((Operator)Ops.LT, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)});
            }
            case LE: {
                return Expressions.predicate((Operator)Ops.LOE, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)});
            }
            case EQ: {
                if (fieldValue == null) {
                    return Expressions.predicate((Operator)Ops.IS_NULL, (Expression[])new Expression[]{(Expression)wherePath.getPath()});
                }
                return Expressions.predicate((Operator)Ops.EQ, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)});
            }
            case NE: {
                if (fieldValue == null) {
                    return Expressions.predicate((Operator)Ops.IS_NOT_NULL, (Expression[])new Expression[]{(Expression)wherePath.getPath()});
                }
                return Expressions.predicate((Operator)Ops.NE, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)});
            }
            case GE: {
                return Expressions.predicate((Operator)Ops.GOE, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)});
            }
            case GT: {
                return Expressions.predicate((Operator)Ops.GT, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)});
            }
            case LIKE: {
                return Expressions.predicate((Operator)Ops.LIKE, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)});
            }
            case UNLIKE: {
                return Expressions.predicate((Operator)Ops.NOT, (Expression[])new Expression[]{Expressions.predicate((Operator)Ops.LIKE, (Expression[])new Expression[]{(Expression)wherePath.getPath(), Expressions.constant(fieldValue)})});
            }
            case IN: {
                int arrayLength = Array.getLength(fieldValue);
                if (arrayLength == 0) {
                    return null;
                }
                CollectionExpression collectionExpression = Expressions.collectionOperation(fieldValue.getClass().getComponentType(), (Operator)Ops.SINGLETON, (Expression[])new Expression[]{Expressions.constant((Object)Array.get(fieldValue, 0))});
                if (arrayLength > 1) {
                    for (int index = 1; index < arrayLength; ++index) {
                        collectionExpression = Expressions.collectionOperation(fieldValue.getClass().getComponentType(), (Operator)Ops.LIST, (Expression[])new Expression[]{collectionExpression, Expressions.constant((Object)Array.get(fieldValue, index))});
                    }
                }
                return Expressions.predicate((Operator)Ops.IN, (Expression[])new Expression[]{(Expression)wherePath.getPath(), collectionExpression});
            }
        }
        throw new UnknownSwitchCaseException(whereField.getOperator().name(), new Object[0]);
    }

    public static Product<Path<?>, OrderSpecifier[]> apply(Sort sort, WhereFieldTransformer<Path<?>, Path<?>> fieldTransformer) {
        if (sort != null && !sort.isEmpty()) {
            HashSet rootSet = new HashSet();
            LinkedList<OrderSpecifier> orderSpecifierList = new LinkedList<OrderSpecifier>();
            block4: for (SortField sortField : sort.getFields()) {
                WherePath<Path<?>, Path<?>> wherePath = fieldTransformer.transform(sortField.getEntity(), sortField.getName());
                rootSet.add(wherePath.getRoot());
                switch (sortField.getDirection()) {
                    case ASC: {
                        orderSpecifierList.add(new OrderSpecifier(Order.ASC, (Expression)wherePath.getPath()));
                        continue block4;
                    }
                    case DESC: {
                        orderSpecifierList.add(new OrderSpecifier(Order.DESC, (Expression)wherePath.getPath()));
                        continue block4;
                    }
                    default: {
                        throw new UnknownSwitchCaseException(sortField.getDirection().name(), new Object[0]);
                    }
                }
            }
            OrderSpecifier[] orderSpecifiers = new OrderSpecifier[orderSpecifierList.size()];
            orderSpecifierList.toArray(orderSpecifiers);
            return new SomeProduct(rootSet, orderSpecifiers);
        }
        return NoneProduct.none();
    }
}

