/*
 * Copyright 2013 Adam Dubiel, Przemek Hertel.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.smartparam.engine.functions.java;

import java.lang.reflect.Method;
import org.smartparam.engine.core.exception.SmartParamException;

/**
 *
 * @author Adam Dubiel
 */
@SuppressWarnings("serial")
public class JavaFunctionInvocationException extends SmartParamException {

    JavaFunctionInvocationException(Throwable cause, Object instance, Method method) {
        super("FUNCTION_INVOKE_ERROR", cause,
                String.format("Error invoking method %s on object %s.",
                        method.getName(), instance != null ? instance.getClass().getSimpleName() : "<null>"));
    }

}
