/*
 * Copyright 2013 Adam Dubiel, Przemek Hertel.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.smartparam.engine.types.string;

import org.smartparam.engine.core.type.AbstractValueHolder;

/**
 * Klasa reprezentuje wartosci typu {@link StringType}.
 * Wewnetrza reprezentacja bazuje na polu <tt>value</tt> typu String.
 * Wartosc moze byc rowna null.
 * <p>
 * Obiekty tej klasy sa niezmienne (immutable).
 *
 * @see StringType
 *
 * @author Przemek Hertel
 * @since 1.0.0
 */
public class StringHolder extends AbstractValueHolder {

    /**
     * Wewnetrzna reprezentacja wartosci.
     */
    private String value;

    /**
     * Jedyny sposob wypelnienia obiektu wartoscia.
     *
     * @param value reprezentowana wartosc.
     */
    public StringHolder(String value) {
        this.value = value;
    }

    /**
     * Zwraca wartosc wewnetrzna.
     *
     * @return wartosc wewnetrzna
     */
    @Override
    public String getValue() {
        return value;
    }
}
