/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.repository.jdbc;

import java.util.Set;
import org.polyjdbc.core.exception.TransactionInterruptedException;
import org.polyjdbc.core.query.QueryRunner;
import org.polyjdbc.core.query.TransactionRunner;
import org.polyjdbc.core.query.TransactionWrapper;
import org.polyjdbc.core.query.VoidTransactionWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.config.InitializableComponent;
import org.smartparam.engine.core.batch.ParameterBatchLoader;
import org.smartparam.engine.core.batch.ParameterEntryBatchLoader;
import org.smartparam.engine.core.exception.ParamBatchLoadingException;
import org.smartparam.engine.core.repository.ParamRepository;
import org.smartparam.engine.core.repository.WritableParamRepository;
import org.smartparam.engine.model.Parameter;
import org.smartparam.engine.model.ParameterEntry;
import org.smartparam.repository.jdbc.batch.JdbcParameterEntryBatchLoader;
import org.smartparam.repository.jdbc.batch.JdbcParameterEntryBatchLoaderFactory;
import org.smartparam.repository.jdbc.dao.JdbcRepository;
import org.smartparam.repository.jdbc.model.JdbcParameter;
import org.smartparam.repository.jdbc.schema.SchemaCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcParamRepository
implements ParamRepository,
WritableParamRepository,
InitializableComponent {
    private static final Logger logger = LoggerFactory.getLogger(JdbcParamRepository.class);
    private static final int LOADED_BATCH_SIZE = 500;
    private TransactionRunner transactionRunner;
    private JdbcParameterEntryBatchLoaderFactory batchLoaderFactory;
    private JdbcRepository dao;
    private SchemaCreator schemaCreator;

    public JdbcParamRepository(TransactionRunner operationRunner, JdbcParameterEntryBatchLoaderFactory batchLoaderFactory, JdbcRepository dao, SchemaCreator schemaCreator) {
        this.dao = dao;
        this.schemaCreator = schemaCreator;
        this.batchLoaderFactory = batchLoaderFactory;
        this.transactionRunner = operationRunner;
    }

    public void initialize() {
        this.schemaCreator.createSchema();
    }

    public Set<String> listParameters() {
        return this.dao.getParameterNames();
    }

    public Parameter load(final String parameterName) {
        return (Parameter)this.transactionRunner.run((TransactionWrapper)new TransactionWrapper<Parameter>(){

            public Parameter perform(QueryRunner queryRunner) {
                return JdbcParamRepository.this.dao.getParameter(queryRunner, parameterName);
            }
        });
    }

    public ParameterBatchLoader batchLoad(final String parameterName) {
        return (ParameterBatchLoader)this.transactionRunner.run((TransactionWrapper)new TransactionWrapper<ParameterBatchLoader>(){

            public ParameterBatchLoader perform(QueryRunner queryRunner) {
                JdbcParameter metadata = JdbcParamRepository.this.dao.getParameterMetadata(queryRunner, parameterName);
                JdbcParameterEntryBatchLoader entryLoader = JdbcParamRepository.this.batchLoaderFactory.create(metadata.getId());
                return new ParameterBatchLoader((Parameter)metadata, (ParameterEntryBatchLoader)entryLoader);
            }
        });
    }

    public Set<ParameterEntry> findEntries(String parameterName, String[] levelValues) {
        logger.info("trying to load parameter {}, but {} does not support non-cacheable parameters", (Object)parameterName, (Object)this.getClass().getSimpleName());
        return null;
    }

    public void write(final Parameter parameter) {
        this.transactionRunner.run((TransactionWrapper)new VoidTransactionWrapper(){

            public void performVoid(QueryRunner queryRunner) {
                JdbcParamRepository.this.write(queryRunner, parameter);
            }
        });
    }

    public void write(final ParameterBatchLoader batchLoader) {
        this.transactionRunner.run((TransactionWrapper)new VoidTransactionWrapper(){

            public void performVoid(QueryRunner queryRunner) {
                String parameterName = batchLoader.getMetadata().getName();
                try {
                    JdbcParamRepository.this.write(queryRunner, batchLoader.getMetadata());
                    queryRunner.commit();
                    ParameterEntryBatchLoader entryLoader = batchLoader.getEntryLoader();
                    while (entryLoader.hasMore()) {
                        JdbcParamRepository.this.dao.writeParameterEntries(queryRunner, parameterName, entryLoader.nextBatch(500));
                        queryRunner.commit();
                    }
                }
                catch (ParamBatchLoadingException batchException) {
                    queryRunner.rollback();
                    throw new TransactionInterruptedException((Throwable)batchException);
                }
            }
        });
    }

    public void writeAll(final Iterable<Parameter> parameters) {
        this.transactionRunner.run((TransactionWrapper)new VoidTransactionWrapper(){

            public void performVoid(QueryRunner queryRunner) {
                for (Parameter parameter : parameters) {
                    JdbcParamRepository.this.write(queryRunner, parameter);
                }
            }
        });
    }

    private void write(QueryRunner queryRunner, Parameter parameter) {
        String parameterName = parameter.getName();
        if (this.dao.parameterExists(queryRunner, parameterName)) {
            this.dao.deleteParameter(queryRunner, parameterName);
        }
        this.dao.createParameter(queryRunner, parameter);
    }

    public void writeParameterEntries(final String parameterName, final Iterable<ParameterEntry> parameterEntries) {
        this.transactionRunner.run((TransactionWrapper)new VoidTransactionWrapper(){

            public void performVoid(QueryRunner queryRunner) {
                JdbcParamRepository.this.dao.writeParameterEntries(queryRunner, parameterName, parameterEntries);
            }
        });
    }

    public void delete(final String parameterName) {
        this.transactionRunner.run((TransactionWrapper)new VoidTransactionWrapper(){

            public void performVoid(QueryRunner queryRunner) {
                JdbcParamRepository.this.dao.deleteParameter(queryRunner, parameterName);
            }
        });
    }
}

