/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.repository.jdbc.batch;

import java.util.Collection;
import java.util.List;
import org.polyjdbc.core.query.QueryRunner;
import org.smartparam.engine.core.batch.ParameterEntryBatchLoader;
import org.smartparam.engine.model.ParameterEntry;
import org.smartparam.repository.jdbc.dao.ParameterEntryDAO;
import org.smartparam.repository.jdbc.model.JdbcParameterEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcParameterEntryBatchLoader
implements ParameterEntryBatchLoader {
    private final QueryRunner queryRunner;
    private final ParameterEntryDAO parameterEntryDAO;
    private final long parameterId;
    private long lastEntryId;
    private boolean hasMore = true;

    public JdbcParameterEntryBatchLoader(QueryRunner queryRunner, ParameterEntryDAO parameterEntryDAO, long parameterId) {
        this.parameterEntryDAO = parameterEntryDAO;
        this.parameterId = parameterId;
        this.queryRunner = queryRunner;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public Collection<ParameterEntry> nextBatch(int batchSize) {
        List<ParameterEntry> entries = this.parameterEntryDAO.getParameterEntriesBatch(this.queryRunner, this.parameterId, this.lastEntryId, batchSize);
        this.queryRunner.commit();
        JdbcParameterEntry lastEntry = this.getLastEntry(entries);
        if (lastEntry != null) {
            this.lastEntryId = lastEntry.getId();
        }
        this.hasMore = entries.size() == batchSize;
        return entries;
    }

    private JdbcParameterEntry getLastEntry(List<ParameterEntry> entries) {
        if (entries.isEmpty()) {
            return null;
        }
        return (JdbcParameterEntry)entries.get(entries.size() - 1);
    }

    public void close() {
        this.queryRunner.close();
    }
}

