/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.repository.jdbc.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import org.polyjdbc.core.query.mapper.ObjectMapper;
import org.smartparam.repository.jdbc.config.DefaultJdbcConfig;
import org.smartparam.repository.jdbc.model.JdbcParameterEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcParameterEntryMapper
implements ObjectMapper<JdbcParameterEntry> {
    private DefaultJdbcConfig configuration;

    public JdbcParameterEntryMapper(DefaultJdbcConfig configuration) {
        this.configuration = configuration;
    }

    public JdbcParameterEntry createObject(ResultSet resultSet) throws SQLException {
        String lastLevelValue;
        JdbcParameterEntry entry = new JdbcParameterEntry();
        entry.setId(resultSet.getInt("id"));
        entry.setParameterId(resultSet.getLong("fk_parameter"));
        ArrayList<String> levels = new ArrayList<String>();
        boolean doneBeforeLimit = false;
        for (int levelIndex = 0; levelIndex < this.configuration.getLevelColumnCount() - 1; ++levelIndex) {
            String currentLevelValue = resultSet.getString("level" + (levelIndex + 1));
            if (currentLevelValue == null) {
                doneBeforeLimit = true;
                break;
            }
            levels.add(currentLevelValue);
        }
        if (!doneBeforeLimit && (lastLevelValue = resultSet.getString("level" + this.configuration.getLevelColumnCount())) != null) {
            levels.addAll(Arrays.asList(lastLevelValue.split("\\" + this.configuration.getExcessLevelsSeparator())));
        }
        entry.setLevels(levels.toArray(new String[levels.size()]));
        return entry;
    }
}

