/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.repository.jdbc.dao;

import java.util.List;
import org.polyjdbc.core.query.DeleteQuery;
import org.polyjdbc.core.query.InsertQuery;
import org.polyjdbc.core.query.Order;
import org.polyjdbc.core.query.QueryFactory;
import org.polyjdbc.core.query.QueryRunner;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.query.mapper.ObjectMapper;
import org.smartparam.engine.model.Level;
import org.smartparam.repository.jdbc.config.JdbcConfig;
import org.smartparam.repository.jdbc.dao.JdbcLevelMapper;
import org.smartparam.repository.jdbc.dao.LevelMapper;
import org.smartparam.repository.jdbc.model.JdbcLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelDAO {
    private final JdbcConfig configuration;

    public LevelDAO(JdbcConfig configuration) {
        this.configuration = configuration;
    }

    public void insertParameterLevels(QueryRunner queryRunner, List<Level> levels, long parameterId) {
        int order = 0;
        for (Level level : levels) {
            this.insert(queryRunner, level, parameterId, order);
            ++order;
        }
    }

    public long insert(QueryRunner queryRunner, JdbcLevel level, long parameterId) {
        return this.insert(queryRunner, (Level)level, parameterId, level.getOrderNo());
    }

    private long insert(QueryRunner queryRunner, Level level, long parameterId, int order) {
        InsertQuery query = QueryFactory.insert().into(this.configuration.getLevelTable()).sequence("id", this.configuration.getLevelSequence()).value("fk_parameter", (Object)parameterId).value("name", (Object)level.getName()).value("level_creator", (Object)level.getLevelCreator()).value("type", (Object)level.getType()).value("matcher", (Object)level.getMatcher()).value("order_no", (Object)order).value("array_flag", (Object)level.isArray());
        return queryRunner.insert(query);
    }

    public JdbcLevel getLevel(QueryRunner queryRunner, long id) {
        return (JdbcLevel)queryRunner.queryUnique(QueryFactory.selectAll().from(this.configuration.getLevelTable()).where("id = :id").withArgument("id", (Object)id), (ObjectMapper)new JdbcLevelMapper());
    }

    public List<Level> getLevels(QueryRunner queryRunner, long parameterId) {
        return queryRunner.queryList(this.createSelectQuery(parameterId), (ObjectMapper)new LevelMapper());
    }

    public List<JdbcLevel> getJdbcLevels(QueryRunner queryRunner, long parameterId) {
        return queryRunner.queryList(this.createSelectQuery(parameterId), (ObjectMapper)new JdbcLevelMapper());
    }

    private SelectQuery createSelectQuery(long parameterId) {
        return QueryFactory.selectAll().from(this.configuration.getLevelTable()).where("fk_parameter = :param_id").orderBy("order_no", Order.ASC).withArgument("param_id", (Object)parameterId);
    }

    public void deleteParameterLevels(QueryRunner queryRunner, String parameterName) {
        DeleteQuery query = QueryFactory.delete().from(this.configuration.getLevelTable()).where("fk_parameter = (select id from " + this.configuration.getParameterTable() + " where name = :name)").withArgument("name", (Object)parameterName);
        queryRunner.delete(query);
    }
}

