/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.repository.jdbc.dao;

import java.util.HashSet;
import java.util.Set;
import org.polyjdbc.core.query.DeleteQuery;
import org.polyjdbc.core.query.InsertQuery;
import org.polyjdbc.core.query.QueryFactory;
import org.polyjdbc.core.query.QueryRunner;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.query.SimpleQueryRunner;
import org.polyjdbc.core.query.mapper.ObjectMapper;
import org.polyjdbc.core.query.mapper.StringMapper;
import org.smartparam.engine.model.Parameter;
import org.smartparam.repository.jdbc.config.JdbcConfig;
import org.smartparam.repository.jdbc.dao.ParameterMapper;
import org.smartparam.repository.jdbc.model.JdbcParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterDAO {
    private final JdbcConfig configuration;
    private final SimpleQueryRunner simpleQueryRunner;

    public ParameterDAO(JdbcConfig configuration, SimpleQueryRunner simpleQueryRunner) {
        this.configuration = configuration;
        this.simpleQueryRunner = simpleQueryRunner;
    }

    public long insert(QueryRunner queryRunner, Parameter parameter) {
        InsertQuery query = this.createInsertQuery(parameter);
        query.sequence("id", this.configuration.getParameterSequence());
        return queryRunner.insert(query);
    }

    public long insert(QueryRunner queryRunner, JdbcParameter parameter) {
        boolean generateSequenceId;
        InsertQuery query = this.createInsertQuery((Parameter)parameter);
        boolean bl = generateSequenceId = parameter.getId() == 0L;
        if (generateSequenceId) {
            query.sequence("id", this.configuration.getParameterSequence());
        } else {
            query.value("id", (Object)parameter.getId());
        }
        return queryRunner.insert(query);
    }

    private InsertQuery createInsertQuery(Parameter parameter) {
        InsertQuery query = QueryFactory.insert().into(this.configuration.getParameterTable()).value("name", (Object)parameter.getName()).value("input_levels", (Object)parameter.getInputLevels()).value("cacheable", (Object)parameter.isCacheable()).value("nullable", (Object)parameter.isNullable()).value("array_separator", (Object)Character.valueOf(parameter.getArraySeparator()));
        return query;
    }

    public void delete(QueryRunner queryRunner, String parameterName) {
        DeleteQuery query = QueryFactory.delete().from(this.configuration.getParameterTable()).where("name = :name").withArgument("name", (Object)parameterName);
        queryRunner.delete(query);
    }

    public Set<String> getParameterNames() {
        SelectQuery query = QueryFactory.select((String)"name").from(this.configuration.getParameterTable());
        return new HashSet<String>(this.simpleQueryRunner.queryList(query, (ObjectMapper)new StringMapper()));
    }

    public JdbcParameter getParameter(QueryRunner queryRunner, String parameterName) {
        SelectQuery query = QueryFactory.selectAll().from(this.configuration.getParameterTable()).where("name = :name").withArgument("name", (Object)parameterName);
        return (JdbcParameter)queryRunner.queryUnique(query, (ObjectMapper)new ParameterMapper(), false);
    }

    public boolean parameterExists(String parameterName) {
        SelectQuery query = QueryFactory.selectAll().from(this.configuration.getParameterTable()).where("name = :name").withArgument("name", (Object)parameterName);
        return this.simpleQueryRunner.queryExistence(query);
    }
}

