/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.repository.jdbc.dao;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.polyjdbc.core.query.DeleteQuery;
import org.polyjdbc.core.query.InsertQuery;
import org.polyjdbc.core.query.Order;
import org.polyjdbc.core.query.QueryFactory;
import org.polyjdbc.core.query.QueryRunner;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.query.mapper.ObjectMapper;
import org.polyjdbc.core.util.StringUtils;
import org.smartparam.engine.model.ParameterEntry;
import org.smartparam.repository.jdbc.config.DefaultJdbcConfig;
import org.smartparam.repository.jdbc.dao.JdbcParameterEntryMapper;
import org.smartparam.repository.jdbc.dao.ParameterEntryMapper;
import org.smartparam.repository.jdbc.model.JdbcParameterEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterEntryDAO {
    private final DefaultJdbcConfig configuration;

    public ParameterEntryDAO(DefaultJdbcConfig configuration) {
        this.configuration = configuration;
    }

    public void insert(QueryRunner queryRunner, Iterable<ParameterEntry> parameterEntries, long parameterId) {
        int maxDistinctLevels = this.configuration.getLevelColumnCount();
        for (ParameterEntry entry : parameterEntries) {
            InsertQuery query = QueryFactory.insert().into(this.configuration.getParameterEntryTable()).sequence("id", this.configuration.getParameterEntrySequence()).value("fk_parameter", (Object)parameterId);
            for (int levelIndex = 0; levelIndex < maxDistinctLevels - 1 && levelIndex < entry.getLevels().length; ++levelIndex) {
                query.value("level" + (levelIndex + 1), (Object)entry.getLevels()[levelIndex]);
            }
            if (entry.getLevels().length > maxDistinctLevels) {
                query.value("level" + maxDistinctLevels, (Object)this.concatenateLastLevels(entry.getLevels(), maxDistinctLevels));
            } else if (entry.getLevels().length == maxDistinctLevels) {
                query.value("level" + maxDistinctLevels, (Object)entry.getLevels()[maxDistinctLevels - 1]);
            }
            queryRunner.insert(query);
        }
    }

    private String concatenateLastLevels(String[] entryLevels, int maxDistinctLevels) {
        String[] excessLevels = Arrays.copyOfRange(entryLevels, maxDistinctLevels - 1, entryLevels.length);
        return StringUtils.concatenate((char)this.configuration.getExcessLevelsSeparator(), (Object[])excessLevels);
    }

    public Set<ParameterEntry> getParameterEntries(QueryRunner queryRunner, long parameterId) {
        return queryRunner.querySet(this.createSelectQuery(parameterId), (ObjectMapper)new ParameterEntryMapper(this.configuration));
    }

    public Set<JdbcParameterEntry> getJdbcParameterEntries(QueryRunner queryRunner, long parameterId) {
        return queryRunner.querySet(this.createSelectQuery(parameterId), (ObjectMapper)new JdbcParameterEntryMapper(this.configuration));
    }

    public List<ParameterEntry> getParameterEntriesBatch(QueryRunner queryRunner, long parameterId, long lastEntryId, int batchSize) {
        SelectQuery query = this.createSelectQuery(parameterId);
        query.append(" and id > :lastId ").withArgument("lastId", (Object)lastEntryId).orderBy("id", Order.ASC).limit(batchSize);
        return queryRunner.queryList(query, (ObjectMapper)new ParameterEntryMapper(this.configuration));
    }

    private SelectQuery createSelectQuery(long parameterId) {
        return QueryFactory.selectAll().from(this.configuration.getParameterEntryTable()).where("fk_parameter = :parameterId").withArgument("parameterId", (Object)parameterId);
    }

    public void deleteParameterEntries(QueryRunner queryRunner, String parameterName) {
        DeleteQuery query = QueryFactory.delete().from(this.configuration.getParameterEntryTable()).where("fk_parameter = (select id from " + this.configuration.getParameterTable() + " where name = :name)").withArgument("name", (Object)parameterName);
        queryRunner.delete(query);
    }
}

