/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.repository.jdbc.dao;

import java.util.ArrayList;
import java.util.Set;
import org.polyjdbc.core.query.QueryRunner;
import org.smartparam.engine.core.exception.SmartParamException;
import org.smartparam.engine.model.Level;
import org.smartparam.engine.model.Parameter;
import org.smartparam.engine.model.ParameterEntry;
import org.smartparam.repository.jdbc.config.JdbcConfig;
import org.smartparam.repository.jdbc.dao.JdbcRepository;
import org.smartparam.repository.jdbc.dao.LevelDAO;
import org.smartparam.repository.jdbc.dao.ParameterDAO;
import org.smartparam.repository.jdbc.dao.ParameterEntryDAO;
import org.smartparam.repository.jdbc.model.JdbcParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJdbcRepository
implements JdbcRepository {
    private JdbcConfig configuration;
    private ParameterDAO parameterDAO;
    private LevelDAO levelDAO;
    private ParameterEntryDAO parameterEntryDAO;

    public SimpleJdbcRepository(JdbcConfig configuration, ParameterDAO parameterDAO, LevelDAO levelDAO, ParameterEntryDAO parameterEntryDAO) {
        this.configuration = configuration;
        this.checkConfiguration();
        this.parameterDAO = parameterDAO;
        this.levelDAO = levelDAO;
        this.parameterEntryDAO = parameterEntryDAO;
    }

    private void checkConfiguration() {
        if (this.configuration.getDialect() == null) {
            throw new SmartParamException("Provided JDBC repository configuration has no dialect defined!");
        }
    }

    @Override
    public void createParameter(QueryRunner runner, Parameter parameter) {
        long parameterId = this.parameterDAO.insert(runner, parameter);
        this.levelDAO.insertParameterLevels(runner, parameter.getLevels(), parameterId);
        this.parameterEntryDAO.insert(runner, parameter.getEntries(), parameterId);
    }

    @Override
    public boolean parameterExists(QueryRunner runner, String parameterName) {
        return this.parameterDAO.parameterExists(parameterName);
    }

    @Override
    public JdbcParameter getParameter(QueryRunner runner, String parameterName) {
        JdbcParameter parameter = this.getParameterMetadata(runner, parameterName);
        Set<ParameterEntry> entries = this.parameterEntryDAO.getParameterEntries(runner, parameter.getId());
        parameter.setEntries(entries);
        return parameter;
    }

    @Override
    public JdbcParameter getParameterMetadata(QueryRunner runner, String parameterName) {
        JdbcParameter parameter = this.parameterDAO.getParameter(runner, parameterName);
        ArrayList<Level> levels = new ArrayList<Level>(this.levelDAO.getLevels(runner, parameter.getId()));
        parameter.setLevels(levels);
        return parameter;
    }

    @Override
    public Set<String> getParameterNames() {
        return this.parameterDAO.getParameterNames();
    }

    @Override
    public Set<ParameterEntry> getParameterEntries(QueryRunner runner, long parameterId) {
        return this.parameterEntryDAO.getParameterEntries(runner, parameterId);
    }

    @Override
    public void writeParameterEntries(QueryRunner runner, String parameterName, Iterable<ParameterEntry> entries) {
        JdbcParameter parameter = this.parameterDAO.getParameter(runner, parameterName);
        this.parameterEntryDAO.insert(runner, entries, parameter.getId());
    }

    @Override
    public void deleteParameter(QueryRunner runner, String parameterName) {
        this.parameterEntryDAO.deleteParameterEntries(runner, parameterName);
        this.levelDAO.deleteParameterLevels(runner, parameterName);
        this.parameterDAO.delete(runner, parameterName);
    }
}

