/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.repository.jdbc.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.smartparam.engine.model.Level;
import org.smartparam.engine.model.ParameterEntry;
import org.smartparam.engine.model.editable.EditableParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcParameter
implements EditableParameter {
    public static final char DEFAULT_ARRAY_SEPARATOR = ',';
    private long id;
    private String name;
    private List<Level> levels = new ArrayList<Level>();
    private Set<ParameterEntry> entries = new HashSet<ParameterEntry>();
    private int inputLevels;
    private boolean nullable;
    private boolean cacheable = true;
    private char arraySeparator = (char)44;

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Level> getLevels() {
        return this.levels;
    }

    public int getLevelCount() {
        return this.levels != null ? this.levels.size() : 0;
    }

    public int getInputLevels() {
        return this.inputLevels;
    }

    public Set<ParameterEntry> getEntries() {
        return this.entries;
    }

    public char getArraySeparator() {
        return this.arraySeparator;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Parameter#").append(this.id);
        sb.append('[').append(this.name);
        sb.append(", levels=").append(this.getLevelCount());
        sb.append(", inputLevels=").append(this.getInputLevels());
        sb.append(this.nullable ? ", nullable" : ", notnull");
        if (!this.cacheable) {
            sb.append(", nocache");
        }
        sb.append(']');
        return sb.toString();
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLevels(List<Level> levels) {
        this.levels.clear();
        this.levels.addAll(levels);
    }

    public void setEntries(Set<ParameterEntry> entries) {
        this.entries.clear();
        this.entries.addAll(entries);
    }

    public void setInputLevels(int inputLevels) {
        this.inputLevels = inputLevels;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }

    public void setArraySeparator(char arraySeparator) {
        this.arraySeparator = arraySeparator;
    }
}

