/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.repository.jdbc.schema;

import java.io.Closeable;
import org.polyjdbc.core.schema.SchemaInspector;
import org.polyjdbc.core.schema.SchemaManager;
import org.polyjdbc.core.schema.SchemaManagerFactory;
import org.polyjdbc.core.schema.model.BooleanAttributeBuilder;
import org.polyjdbc.core.schema.model.CharAttributeBuilder;
import org.polyjdbc.core.schema.model.IntegerAttributeBuilder;
import org.polyjdbc.core.schema.model.LongAttributeBuilder;
import org.polyjdbc.core.schema.model.RelationBuilder;
import org.polyjdbc.core.schema.model.Schema;
import org.polyjdbc.core.schema.model.StringAttributeBuilder;
import org.polyjdbc.core.util.TheCloser;
import org.smartparam.repository.jdbc.config.DefaultJdbcConfig;
import org.smartparam.repository.jdbc.schema.SchemaCreator;
import org.smartparam.repository.jdbc.schema.SchemaNamePolicy;

public class DefaultSchemaCreator
implements SchemaCreator {
    private final DefaultJdbcConfig configuration;
    private final SchemaManagerFactory schemaManagerFactory;

    public DefaultSchemaCreator(DefaultJdbcConfig configuration, SchemaManagerFactory schemaManagerFactory) {
        this.configuration = configuration;
        this.schemaManagerFactory = schemaManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema() {
        SchemaManager schemaManager = null;
        SchemaInspector schemaInspector = null;
        try {
            schemaManager = this.schemaManagerFactory.createManager();
            schemaInspector = this.schemaManagerFactory.createInspector();
            Schema schema = new Schema(this.configuration.getDialect());
            this.createParameterRelation(schema, schemaInspector);
            this.createLevelRelation(schema, schemaInspector);
            this.createParameterEntryRelation(schema, schemaInspector);
            schemaManager.create(schema);
        }
        catch (Throwable throwable) {
            TheCloser.close((Closeable[])new Closeable[]{schemaManager, schemaInspector});
            throw throwable;
        }
        TheCloser.close((Closeable[])new Closeable[]{schemaManager, schemaInspector});
    }

    protected void createParameterRelation(Schema schema, SchemaInspector schemaInspector) {
        String relationName = this.configuration.getParameterTable();
        if (!schemaInspector.relationExists(relationName)) {
            ((CharAttributeBuilder)((CharAttributeBuilder)((BooleanAttributeBuilder)((BooleanAttributeBuilder)((BooleanAttributeBuilder)((BooleanAttributeBuilder)((IntegerAttributeBuilder)((StringAttributeBuilder)((StringAttributeBuilder)((LongAttributeBuilder)((LongAttributeBuilder)schema.addRelation(relationName).withAttribute().longAttr("id").withAdditionalModifiers(new String[]{"AUTO_INCREMENT"})).notNull()).and().withAttribute().string("name").withMaxLength(200).notNull()).unique()).and().withAttribute().integer("input_levels").notNull()).and().withAttribute().booleanAttr("cacheable").notNull()).withDefaultValue((Object)true)).and().withAttribute().booleanAttr("nullable").notNull()).withDefaultValue((Object)false)).and().withAttribute().character("array_separator").notNull()).withDefaultValue((Object)Character.valueOf(';'))).and().primaryKey(SchemaNamePolicy.primaryKey(relationName)).using(new String[]{"id"}).and().build();
            schema.addSequence(this.configuration.getParameterSequence()).build();
        }
    }

    protected void createLevelRelation(Schema schema, SchemaInspector schemaInspector) {
        String relationName = this.configuration.getLevelTable();
        if (!schemaInspector.relationExists(relationName)) {
            ((LongAttributeBuilder)((IntegerAttributeBuilder)((BooleanAttributeBuilder)((BooleanAttributeBuilder)((StringAttributeBuilder)((LongAttributeBuilder)((LongAttributeBuilder)schema.addRelation(relationName).withAttribute().longAttr("id").withAdditionalModifiers(new String[]{"AUTO_INCREMENT"})).notNull()).and().withAttribute().string("name").withMaxLength(200).and().withAttribute().string("type").withMaxLength(100).notNull()).and().withAttribute().string("matcher").withMaxLength(100).and().withAttribute().string("level_creator").withMaxLength(200).and().withAttribute().booleanAttr("array_flag").notNull()).withDefaultValue((Object)false)).and().withAttribute().integer("order_no").notNull()).and().withAttribute().longAttr(SchemaNamePolicy.foreignKey("parameter")).notNull()).and().primaryKey(SchemaNamePolicy.primaryKey(relationName)).using(new String[]{"id"}).and().foreignKey(SchemaNamePolicy.foreignKey(this.configuration.getParameterTable() + "_id")).references(this.configuration.getParameterTable(), "id").on(SchemaNamePolicy.foreignKey("parameter")).and().build();
            schema.addSequence(this.configuration.getLevelSequence()).build();
        }
    }

    protected void createParameterEntryRelation(Schema schema, SchemaInspector schemaInspector) {
        String relationName = this.configuration.getParameterEntryTable();
        if (!schemaInspector.relationExists(relationName)) {
            RelationBuilder builder = RelationBuilder.relation((Schema)schema, (String)relationName);
            ((LongAttributeBuilder)((LongAttributeBuilder)((LongAttributeBuilder)builder.withAttribute().longAttr("id").withAdditionalModifiers(new String[]{"AUTO_INCREMENT"})).notNull()).and().withAttribute().longAttr(SchemaNamePolicy.foreignKey("parameter")).notNull()).and();
            for (int levelIndex = 0; levelIndex < this.configuration.getLevelColumnCount(); ++levelIndex) {
                builder.string("level" + (levelIndex + 1)).withMaxLength(255).and();
            }
            builder.primaryKey(SchemaNamePolicy.primaryKey(relationName)).using(new String[]{"id"}).and().foreignKey(SchemaNamePolicy.foreignKey(this.configuration.getParameterTable() + "id")).references(this.configuration.getParameterTable(), "id").on(SchemaNamePolicy.foreignKey("parameter")).and().build();
            schema.addSequence(this.configuration.getParameterEntrySequence()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchema() {
        SchemaManager schemaManager = null;
        try {
            schemaManager = this.schemaManagerFactory.createManager();
            Schema schema = new Schema(this.configuration.getDialect());
            schema.addRelation(this.configuration.getParameterTable()).build();
            schema.addSequence(this.configuration.getParameterSequence()).build();
            schema.addRelation(this.configuration.getLevelTable()).build();
            schema.addSequence(this.configuration.getLevelSequence()).build();
            schema.addRelation(this.configuration.getParameterEntryTable()).build();
            schema.addSequence(this.configuration.getParameterEntrySequence()).build();
            schemaManager.drop(schema);
        }
        catch (Throwable throwable) {
            TheCloser.close((Closeable[])new Closeable[]{schemaManager});
            throw throwable;
        }
        TheCloser.close((Closeable[])new Closeable[]{schemaManager});
    }
}

