/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.snapscript.agent.ProcessContext;
import org.snapscript.agent.ProcessMode;
import org.snapscript.agent.ProcessTerminator;
import org.snapscript.agent.event.PingEvent;
import org.snapscript.agent.event.PongEvent;
import org.snapscript.agent.event.ProcessEventChannel;
import org.snapscript.common.thread.ThreadBuilder;

public class ConnectionChecker {
    private final ProcessContext context;
    private final ThreadFactory factory;
    private final HealthChecker checker = new HealthChecker(10000L);
    private final AtomicBoolean active;
    private final AtomicLong update;
    private final String process;
    private final String system;

    public ConnectionChecker(ProcessContext context, String process, String system) {
        this.factory = new ThreadBuilder();
        this.active = new AtomicBoolean();
        this.update = new AtomicLong();
        this.context = context;
        this.process = process;
        this.system = system;
    }

    public void update(ProcessEventChannel channel, PingEvent event, String project, String resource) {
        PongEvent pong = new PongEvent.Builder(this.process).withSystem(this.system).withProject(project).withResource(resource).withRunning(resource != null).build();
        try {
            CountDownLatch latch = this.context.getLatch();
            ProcessMode mode = this.context.getMode();
            long time = System.currentTimeMillis();
            if (mode.isDetachRequired()) {
                long count = latch.getCount();
                if (count > 0L) {
                    if (!channel.send(pong)) {
                        ProcessTerminator.terminate("Ping failed for " + this.process);
                    } else {
                        this.update.set(time);
                    }
                }
            } else if (!channel.send(pong)) {
                ProcessTerminator.terminate("Ping failed for " + this.process);
            } else {
                this.update.set(time);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ProcessTerminator.terminate("Ping failed for " + this.process + " with " + e);
        }
    }

    public void start() {
        if (this.active.compareAndSet(false, true)) {
            Thread thread = this.factory.newThread(this.checker);
            thread.start();
        }
    }

    private class HealthChecker
    implements Runnable {
        private final long frequency;

        public HealthChecker(long frequency) {
            this.frequency = frequency;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProcessMode mode = ConnectionChecker.this.context.getMode();
            try {
                long last;
                long time;
                long duration;
                do {
                    Thread.sleep(this.frequency);
                    last = ConnectionChecker.this.update.get();
                } while ((duration = (time = System.currentTimeMillis()) - last) <= this.frequency);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (mode.isTerminateRequired()) {
                    ProcessTerminator.terminate("Connection checker timeout elapsed");
                }
            }
        }
    }
}

