/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.snapscript.agent.ExceptionBuilder;
import org.snapscript.agent.ProcessEventStream;
import org.snapscript.agent.event.ProcessEventChannel;
import org.snapscript.agent.event.ProcessEventType;

public class ConsoleConnector {
    private final ProcessEventStream errorAdapter;
    private final ProcessEventStream outputAdapter;
    private final PrintStream output;
    private final PrintStream error;

    public ConsoleConnector(ProcessEventChannel channel, String process) throws Exception {
        this.errorAdapter = new ProcessEventStream(ProcessEventType.WRITE_ERROR, channel, System.err, process);
        this.outputAdapter = new ProcessEventStream(ProcessEventType.WRITE_OUTPUT, channel, System.out, process);
        this.output = new ConsoleStream(this.outputAdapter, System.out, true, "UTF-8");
        this.error = new ConsoleStream(this.errorAdapter, System.err, true, "UTF-8");
    }

    public void connect() {
        try {
            System.setOut(this.output);
            System.setErr(this.error);
        }
        catch (Exception e) {
            System.err.println(ExceptionBuilder.build(e));
        }
    }

    private static class ConsoleStream
    extends PrintStream {
        private final PrintStream stream;

        public ConsoleStream(OutputStream out, PrintStream stream, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
            super(out, autoFlush, encoding);
            this.stream = stream;
        }

        @Override
        public void close() {
            this.stream.close();
        }
    }
}

