/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent;

import java.net.URI;
import org.snapscript.agent.ConnectionChecker;
import org.snapscript.agent.ProcessAgentService;
import org.snapscript.agent.ProcessContext;
import org.snapscript.agent.ProcessEventReceiver;
import org.snapscript.agent.ProcessMode;
import org.snapscript.agent.ProcessResourceExecutor;
import org.snapscript.agent.SystemValidator;
import org.snapscript.agent.debug.BreakpointMatcher;
import org.snapscript.agent.debug.FaultContextExtractor;
import org.snapscript.agent.debug.SuspendController;
import org.snapscript.agent.debug.SuspendInterceptor;
import org.snapscript.agent.event.ProcessEventChannel;
import org.snapscript.agent.event.ProcessEventTimer;
import org.snapscript.agent.event.RegisterEvent;
import org.snapscript.agent.event.client.ProcessEventClient;
import org.snapscript.agent.log.ConsoleLog;
import org.snapscript.agent.log.ProcessLogger;
import org.snapscript.agent.profiler.ProcessProfiler;
import org.snapscript.core.EmptyModel;
import org.snapscript.core.Model;
import org.snapscript.core.trace.TraceInterceptor;

public class ProcessAgent {
    private final ProcessContext context;
    private final ProcessMode mode;
    private final String system;
    private final String process;
    private final String level;
    private final Model model;
    private final URI root;

    public ProcessAgent(ProcessMode mode, URI root, String system, String process, String level) {
        this(mode, root, system, process, level, 0);
    }

    public ProcessAgent(ProcessMode mode, URI root, String system, String process, String level, int threads) {
        this(mode, root, system, process, level, threads, 0);
    }

    public ProcessAgent(ProcessMode mode, URI root, String system, String process, String level, int threads, int stack) {
        this.context = new ProcessContext(mode, root, process, threads, stack);
        this.model = new EmptyModel();
        this.process = process;
        this.system = system;
        this.level = level;
        this.root = root;
        this.mode = mode;
    }

    public ProcessAgentService start() throws Exception {
        return this.start(this.model);
    }

    public ProcessAgentService start(Model model) throws Exception {
        BreakpointMatcher matcher = this.context.getMatcher();
        SuspendController controller = this.context.getController();
        TraceInterceptor interceptor = this.context.getInterceptor();
        ProcessProfiler profiler = this.context.getProfiler();
        String host = this.root.getHost();
        int port = this.root.getPort();
        try {
            ConsoleLog log = new ConsoleLog();
            ProcessLogger logger = new ProcessLogger(log, this.level);
            SystemValidator validator = new SystemValidator(this.context);
            ConnectionChecker checker = new ConnectionChecker(this.context, this.process, this.system);
            ProcessResourceExecutor executor = new ProcessResourceExecutor(this.context, this.mode, model);
            ProcessEventReceiver listener = new ProcessEventReceiver(this.context, this.mode, checker, executor, model);
            ProcessEventTimer timer = new ProcessEventTimer(listener, logger);
            ProcessEventClient client = new ProcessEventClient(timer, logger);
            ProcessEventChannel channel = client.connect(host, port);
            SuspendInterceptor suspender = new SuspendInterceptor(channel, matcher, controller, this.process);
            FaultContextExtractor extractor = new FaultContextExtractor(channel, logger, this.process);
            RegisterEvent register = new RegisterEvent.Builder(this.process).withSystem(this.system).build();
            interceptor.register(profiler);
            interceptor.register(suspender);
            interceptor.register(extractor);
            channel.send(register);
            validator.validate();
            checker.start();
            return new ProcessAgentService(this.context, channel, executor, this.mode, model);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start process '" + this.process + "'", e);
        }
    }
}

