/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.snapscript.agent.ProcessContext;
import org.snapscript.agent.ProcessMode;
import org.snapscript.agent.ProcessResourceExecutor;
import org.snapscript.agent.ProcessStore;
import org.snapscript.agent.debug.BreakpointMatcher;
import org.snapscript.agent.event.ProcessEventChannel;
import org.snapscript.core.Model;
import org.snapscript.core.ResourceManager;

public class ProcessAgentService {
    private final Map<String, Map<Integer, Boolean>> breakpoints = new HashMap<String, Map<Integer, Boolean>>();
    private final ProcessEventChannel channel;
    private final ProcessResourceExecutor executor;
    private final ProcessContext context;

    public ProcessAgentService(ProcessContext context, ProcessEventChannel channel, ProcessResourceExecutor executor, ProcessMode mode, Model model) {
        this.executor = executor;
        this.channel = channel;
        this.context = context;
    }

    public String loadScript(String project, String resource) {
        ResourceManager manager = this.context.getManager();
        String path = ProcessStore.getPath(project, resource);
        return manager.getString(path);
    }

    public void createBreakpoint(String resource, int line) {
        Map<Integer, Boolean> lines = this.breakpoints.get(resource);
        BreakpointMatcher matcher = this.context.getMatcher();
        if (lines == null) {
            lines = new HashMap<Integer, Boolean>();
            this.breakpoints.put(resource, lines);
        }
        lines.put(line, Boolean.TRUE);
        matcher.update(this.breakpoints);
    }

    public void removeBreakpoint(String resource, int line) {
        Map<Integer, Boolean> lines = this.breakpoints.get(resource);
        BreakpointMatcher matcher = this.context.getMatcher();
        if (lines == null) {
            lines = new HashMap<Integer, Boolean>();
            this.breakpoints.put(resource, lines);
        }
        lines.put(line, Boolean.FALSE);
        matcher.update(this.breakpoints);
    }

    public void execute(String project, String resource) {
        BreakpointMatcher matcher = this.context.getMatcher();
        ProcessStore store = this.context.getStore();
        String actual = this.context.getProcess();
        matcher.update(this.breakpoints);
        store.update(project);
        this.executor.execute(this.channel, actual, project, resource);
    }

    public boolean join(long time) {
        CountDownLatch latch = this.context.getLatch();
        try {
            latch.await();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

