/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent;

import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.snapscript.agent.ProcessMode;
import org.snapscript.agent.ProcessStore;
import org.snapscript.agent.debug.BreakpointMatcher;
import org.snapscript.agent.debug.SuspendController;
import org.snapscript.agent.profiler.ProcessProfiler;
import org.snapscript.common.thread.ThreadPool;
import org.snapscript.compile.ResourceCompiler;
import org.snapscript.compile.StoreContext;
import org.snapscript.core.EmptyModel;
import org.snapscript.core.Model;
import org.snapscript.core.ResourceManager;
import org.snapscript.core.link.PackageLinker;
import org.snapscript.core.trace.TraceInterceptor;

public class ProcessContext {
    private final SuspendController controller;
    private final ResourceCompiler compiler;
    private final ProcessProfiler profiler;
    private final BreakpointMatcher matcher;
    private final StoreContext context;
    private final CountDownLatch latch = new CountDownLatch(1);
    private final ProcessStore store;
    private final ProcessMode mode;
    private final Executor executor;
    private final Model model;
    private final String process;

    public ProcessContext(ProcessMode mode, URI root, String process, int port) {
        this(mode, root, process, port, 4);
    }

    public ProcessContext(ProcessMode mode, URI root, String process, int port, int threads) {
        this(mode, root, process, port, threads, 0);
    }

    public ProcessContext(ProcessMode mode, URI root, String process, int port, int threads, int stack) {
        this.store = new ProcessStore(root);
        this.executor = new ThreadPool(threads, stack);
        this.context = new StoreContext(this.store, this.executor);
        this.compiler = new ResourceCompiler(this.context);
        this.controller = new SuspendController();
        this.matcher = new BreakpointMatcher();
        this.profiler = new ProcessProfiler();
        this.model = new EmptyModel();
        this.process = process;
        this.mode = mode;
    }

    public ProcessMode getMode() {
        return this.mode;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public ResourceManager getManager() {
        return this.context.getManager();
    }

    public PackageLinker getLinker() {
        return this.context.getLinker();
    }

    public TraceInterceptor getInterceptor() {
        return this.context.getInterceptor();
    }

    public ResourceCompiler getCompiler() {
        return this.compiler;
    }

    public ProcessProfiler getProfiler() {
        return this.profiler;
    }

    public BreakpointMatcher getMatcher() {
        return this.matcher;
    }

    public SuspendController getController() {
        return this.controller;
    }

    public ProcessStore getStore() {
        return this.store;
    }

    public Model getModel() {
        return this.model;
    }

    public String getProcess() {
        return this.process;
    }
}

