/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent;

import java.util.Map;
import java.util.Set;
import org.snapscript.agent.ConnectionChecker;
import org.snapscript.agent.ProcessContext;
import org.snapscript.agent.ProcessMode;
import org.snapscript.agent.ProcessResourceExecutor;
import org.snapscript.agent.ProcessStore;
import org.snapscript.agent.ProcessTerminator;
import org.snapscript.agent.debug.BreakpointMatcher;
import org.snapscript.agent.debug.ResumeType;
import org.snapscript.agent.debug.SuspendController;
import org.snapscript.agent.event.BreakpointsEvent;
import org.snapscript.agent.event.BrowseEvent;
import org.snapscript.agent.event.EvaluateEvent;
import org.snapscript.agent.event.ExecuteData;
import org.snapscript.agent.event.ExecuteEvent;
import org.snapscript.agent.event.PingEvent;
import org.snapscript.agent.event.ProcessEventAdapter;
import org.snapscript.agent.event.ProcessEventChannel;
import org.snapscript.agent.event.StepEvent;
import org.snapscript.core.Model;

public class ProcessEventReceiver
extends ProcessEventAdapter {
    private final ConnectionChecker checker;
    private final ProcessResourceExecutor executor;
    private final ProcessContext context;

    public ProcessEventReceiver(ProcessContext context, ProcessMode mode, ConnectionChecker checker, ProcessResourceExecutor executor, Model model) throws Exception {
        this.executor = executor;
        this.checker = checker;
        this.context = context;
    }

    @Override
    public void onExecute(ProcessEventChannel channel, ExecuteEvent event) throws Exception {
        ExecuteData data = event.getData();
        Map<String, Map<Integer, Boolean>> breakpoints = event.getBreakpoints();
        BreakpointMatcher matcher = this.context.getMatcher();
        ProcessStore store = this.context.getStore();
        String actual = this.context.getProcess();
        String target = data.getProcess();
        String project = data.getProject();
        String resource = data.getResource();
        if (!target.equals(actual)) {
            throw new IllegalArgumentException("Process '" + actual + "' received event for '" + target + "'");
        }
        matcher.update(breakpoints);
        store.update(project);
        this.executor.execute(channel, actual, project, resource);
    }

    @Override
    public void onBreakpoints(ProcessEventChannel channel, BreakpointsEvent event) throws Exception {
        Map<String, Map<Integer, Boolean>> breakpoints = event.getBreakpoints();
        BreakpointMatcher matcher = this.context.getMatcher();
        matcher.update(breakpoints);
    }

    @Override
    public void onStep(ProcessEventChannel channel, StepEvent event) throws Exception {
        SuspendController controller = this.context.getController();
        String thread = event.getThread();
        int type = event.getType();
        if (type == 0) {
            controller.resume(ResumeType.RUN, thread);
        } else if (type == 1) {
            controller.resume(ResumeType.STEP_IN, thread);
        } else if (type == 3) {
            controller.resume(ResumeType.STEP_OUT, thread);
        } else if (type == 2) {
            controller.resume(ResumeType.STEP_OVER, thread);
        }
    }

    @Override
    public void onBrowse(ProcessEventChannel channel, BrowseEvent event) throws Exception {
        SuspendController controller = this.context.getController();
        String thread = event.getThread();
        Set<String> expand = event.getExpand();
        controller.browse(expand, thread);
    }

    @Override
    public void onEvaluate(ProcessEventChannel channel, EvaluateEvent event) throws Exception {
        SuspendController controller = this.context.getController();
        String thread = event.getThread();
        String expression = event.getExpression();
        Set<String> expand = event.getExpand();
        boolean refresh = event.isRefresh();
        controller.evaluate(expand, thread, expression, refresh);
    }

    @Override
    public void onPing(ProcessEventChannel channel, PingEvent event) throws Exception {
        ExecuteData data = this.executor.get();
        if (data != null) {
            String project = data.getProject();
            String resource = data.getResource();
            this.checker.update(channel, event, project, resource);
        } else {
            this.checker.update(channel, event, null, null);
        }
    }

    @Override
    public void onClose(ProcessEventChannel channel) throws Exception {
        ProcessTerminator.terminate("Close event received");
    }
}

