/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.agent.ConsoleConnector;
import org.snapscript.agent.ProcessContext;
import org.snapscript.agent.ProcessMode;
import org.snapscript.agent.ProcessTask;
import org.snapscript.agent.event.ExecuteData;
import org.snapscript.agent.event.ProcessEventChannel;
import org.snapscript.common.thread.ThreadBuilder;
import org.snapscript.core.Model;

public class ProcessResourceExecutor {
    private final AtomicReference<ExecuteData> reference = new AtomicReference();
    private final ProcessContext context;
    private final ProcessMode mode;
    private final ThreadFactory factory = new ThreadBuilder();
    private final Model model;

    public ProcessResourceExecutor(ProcessContext context, ProcessMode mode, Model model) {
        this.context = context;
        this.model = model;
        this.mode = mode;
    }

    public void execute(ProcessEventChannel channel, String process, String project, String resource) {
        try {
            ExecuteData data = new ExecuteData(process, project, resource);
            ConsoleConnector connector = new ConsoleConnector(channel, process);
            ProcessTask task = new ProcessTask(channel, this.context, this.mode, this.model, project, resource);
            if (resource != null) {
                Thread thread = this.factory.newThread(task);
                if (this.reference.compareAndSet(null, data)) {
                    connector.connect();
                    thread.start();
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not execute '" + resource + "' from project '" + project + "'", e);
        }
    }

    public ExecuteData get() {
        return this.reference.get();
    }
}

