/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent;

import java.util.SortedSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.snapscript.agent.ExceptionBuilder;
import org.snapscript.agent.ProcessContext;
import org.snapscript.agent.ProcessMode;
import org.snapscript.agent.ProcessTerminator;
import org.snapscript.agent.event.BeginEvent;
import org.snapscript.agent.event.ExitEvent;
import org.snapscript.agent.event.ProcessEventChannel;
import org.snapscript.agent.event.ProfileEvent;
import org.snapscript.agent.profiler.ProcessProfiler;
import org.snapscript.agent.profiler.ProfileResult;
import org.snapscript.agent.profiler.ProfileResultUpdater;
import org.snapscript.compile.Executable;
import org.snapscript.compile.ResourceCompiler;
import org.snapscript.core.Model;

public class ProcessTask
implements Runnable {
    private final ProcessEventChannel client;
    private final ProcessContext context;
    private final ProcessMode mode;
    private final String resource;
    private final String project;
    private final Model model;

    public ProcessTask(ProcessEventChannel client, ProcessContext context, ProcessMode mode, Model model, String project, String resource) {
        this.client = client;
        this.resource = resource;
        this.project = project;
        this.context = context;
        this.model = model;
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        CountDownLatch latch = this.context.getLatch();
        String process = this.context.getProcess();
        long start = System.nanoTime();
        try {
            ProcessProfiler profiler = this.context.getProfiler();
            ResourceCompiler compiler = this.context.getCompiler();
            Executable executable = compiler.compile(this.resource);
            long middle = System.nanoTime();
            ProfileResultUpdater updater = new ProfileResultUpdater(profiler, this.client);
            BeginEvent event = new BeginEvent.Builder(process).withProject(this.project).withResource(this.resource).withMode(this.context.getMode()).withDuration(TimeUnit.NANOSECONDS.toMillis(middle - start)).build();
            this.client.send(event);
            try {
                updater.start(process);
                middle = System.nanoTime();
                executable.execute(this.model);
                return;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return;
            }
            finally {
                try {
                    long stop = System.nanoTime();
                    System.err.flush();
                    System.out.flush();
                    Thread.sleep(200L);
                    SortedSet<ProfileResult> lines = profiler.lines(200);
                    System.err.flush();
                    System.out.flush();
                    ProfileEvent profileEvent = new ProfileEvent.Builder(process).withResults(lines).build();
                    this.client.send(profileEvent);
                    Thread.sleep(2000L);
                    System.err.close();
                    System.out.close();
                    ExitEvent exitEvent = new ExitEvent.Builder(process).withDuration(TimeUnit.NANOSECONDS.toMillis(stop - middle)).withMode(this.context.getMode()).build();
                    this.client.send(exitEvent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (this.mode.isTerminateRequired()) {
                        ProcessTerminator.terminate("Task has finished executing");
                    }
                    latch.countDown();
                }
            }
        }
        catch (Exception e) {
            System.err.println(ExceptionBuilder.build(e));
            return;
        }
        finally {
            if (this.mode.isTerminateRequired()) {
                ProcessTerminator.terminate("Task has finished executing");
            }
            latch.countDown();
        }
    }
}

