/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.debug;

import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.snapscript.core.Context;
import org.snapscript.core.Type;
import org.snapscript.core.convert.ProxyWrapper;
import org.snapscript.core.define.Instance;

public class ArrayStringBuilder {
    private final Context context;
    private final int limit;

    public ArrayStringBuilder(Context context, int limit) {
        this.context = context;
        this.limit = limit;
    }

    public String toString(byte[] array) {
        if (array != null) {
            byte[] copy = new byte[array.length > this.limit ? this.limit : array.length];
            System.arraycopy(array, 0, copy, 0, copy.length);
            return Arrays.toString(copy);
        }
        return "null";
    }

    public String toString(int[] array) {
        if (array != null) {
            int[] copy = new int[array.length > this.limit ? this.limit : array.length];
            System.arraycopy(array, 0, copy, 0, copy.length);
            return Arrays.toString(copy);
        }
        return "null";
    }

    public String toString(long[] array) {
        if (array != null) {
            long[] copy = new long[array.length > this.limit ? this.limit : array.length];
            System.arraycopy(array, 0, copy, 0, copy.length);
            return Arrays.toString(copy);
        }
        return "null";
    }

    public String toString(short[] array) {
        if (array != null) {
            short[] copy = new short[array.length > this.limit ? this.limit : array.length];
            System.arraycopy(array, 0, copy, 0, copy.length);
            return Arrays.toString(copy);
        }
        return "null";
    }

    public String toString(double[] array) {
        if (array != null) {
            double[] copy = new double[array.length > this.limit ? this.limit : array.length];
            System.arraycopy(array, 0, copy, 0, copy.length);
            return Arrays.toString(copy);
        }
        return "null";
    }

    public String toString(float[] array) {
        if (array != null) {
            float[] copy = new float[array.length > this.limit ? this.limit : array.length];
            System.arraycopy(array, 0, copy, 0, copy.length);
            return Arrays.toString(copy);
        }
        return "null";
    }

    public String toString(char[] array) {
        if (array != null) {
            char[] copy = new char[array.length > this.limit ? this.limit : array.length];
            System.arraycopy(array, 0, copy, 0, copy.length);
            return Arrays.toString(copy);
        }
        return "null";
    }

    public String toString(boolean[] array) {
        if (array != null) {
            boolean[] copy = new boolean[array.length > this.limit ? this.limit : array.length];
            System.arraycopy(array, 0, copy, 0, copy.length);
            return Arrays.toString(copy);
        }
        return "null";
    }

    public String toString(Object[] array) {
        HashSet<Object[]> done = new HashSet<Object[]>();
        if (array != null) {
            return this.toString(array, done);
        }
        return "null";
    }

    private String toString(Object[] array, Set<Object[]> done) {
        StringBuilder buffer = new StringBuilder();
        if (array == null) {
            buffer.append("null");
        } else if (array.length == 0) {
            done.add(array);
            buffer.append("[]");
        } else {
            done.add(array);
            buffer.append('[');
            for (int i = 0; i < Math.min(array.length, this.limit); ++i) {
                Object element = array[i];
                int length = buffer.length();
                if (length > this.limit) {
                    return buffer.toString();
                }
                if (i > 0) {
                    buffer.append(", ");
                }
                if (element == null) {
                    buffer.append("null");
                    continue;
                }
                Class<?> entry = element.getClass();
                if (entry.isArray()) {
                    if (entry == byte[].class) {
                        buffer.append(this.toString((byte[])element));
                        continue;
                    }
                    if (entry == short[].class) {
                        buffer.append(this.toString((short[])element));
                        continue;
                    }
                    if (entry == int[].class) {
                        buffer.append(this.toString((int[])element));
                        continue;
                    }
                    if (entry == long[].class) {
                        buffer.append(this.toString((long[])element));
                        continue;
                    }
                    if (entry == char[].class) {
                        buffer.append(this.toString((char[])element));
                        continue;
                    }
                    if (entry == float[].class) {
                        buffer.append(this.toString((float[])element));
                        continue;
                    }
                    if (entry == double[].class) {
                        buffer.append(this.toString((double[])element));
                        continue;
                    }
                    if (entry == boolean[].class) {
                        buffer.append(this.toString((boolean[])element));
                        continue;
                    }
                    if (done.contains(element)) {
                        buffer.append("[...]");
                        continue;
                    }
                    buffer.append(this.toString((Object[])element, done));
                    continue;
                }
                ProxyWrapper wrapper = this.context.getWrapper();
                if (Proxy.class.isInstance(element)) {
                    element = wrapper.fromProxy(element);
                }
                if (Instance.class.isInstance(element)) {
                    Instance instance = (Instance)element;
                    Type type = instance.getType();
                    buffer.append(type);
                    continue;
                }
                buffer.append(element);
            }
            buffer.append(']');
            done.remove(array);
        }
        return buffer.toString();
    }
}

