/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.debug;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.snapscript.agent.debug.ResourceExtractor;

public class BreakpointMatcher {
    private volatile Set[] matches = new Set[0];

    public void update(Map<String, Map<Integer, Boolean>> breakpoints) {
        Set[] copy = new Set[1024];
        Set<String> resources = breakpoints.keySet();
        for (String resource : resources) {
            Map<Integer, Boolean> locations = breakpoints.get(resource);
            Set<Integer> lines = locations.keySet();
            for (Integer line : lines) {
                HashSet<String> set;
                Boolean enabled = locations.get(line);
                if (!enabled.booleanValue()) continue;
                if (line > copy.length) {
                    Set[] temp = new Set[line * 2];
                    for (int i = 0; i < copy.length; ++i) {
                        temp[i] = copy[i];
                    }
                    copy = temp;
                }
                if ((set = copy[line]) == null) {
                    copy[line.intValue()] = set = new HashSet<String>();
                }
                String module = ResourceExtractor.extractModule(resource);
                set.add(module);
                set.add(resource);
            }
        }
        this.matches = copy;
    }

    public boolean isBreakpoint(String resource, int line) {
        Set set;
        if (line < this.matches.length && line >= 0 && (set = this.matches[line]) != null) {
            return set.contains(resource);
        }
        return false;
    }
}

