/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.debug;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.snapscript.agent.debug.ScopeNode;
import org.snapscript.agent.debug.ScopeNodeBuilder;
import org.snapscript.core.Scope;
import org.snapscript.core.State;
import org.snapscript.core.Type;
import org.snapscript.core.TypeTraverser;
import org.snapscript.core.Value;
import org.snapscript.core.define.Instance;
import org.snapscript.core.property.Property;

public class InstanceScopeNode
implements ScopeNode {
    private final TypeTraverser extractor = new TypeTraverser();
    private final ScopeNodeBuilder builder;
    private final List<ScopeNode> nodes = new ArrayList<ScopeNode>();
    private final Scope scope;
    private final String path;
    private final String name;
    private final int depth;

    public InstanceScopeNode(ScopeNodeBuilder builder, Instance scope, String path, String name, int depth) {
        this.builder = builder;
        this.scope = scope;
        this.depth = depth;
        this.name = name;
        this.path = path;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public List<ScopeNode> getNodes() {
        if (this.nodes.isEmpty()) {
            State state = this.scope.getState();
            Iterator names = state.iterator();
            Type type = this.scope.getType();
            Set<Type> types = this.extractor.findHierarchy(type);
            if (names.hasNext() && !types.isEmpty()) {
                HashSet<String> include = new HashSet<String>();
                for (Type base : types) {
                    List<Property> fields = base.getProperties();
                    for (Property property : fields) {
                        String name = property.getName();
                        include.add(name);
                    }
                }
                while (names.hasNext()) {
                    String name = (String)names.next();
                    if (!include.contains(name)) continue;
                    Value value = state.get(name);
                    Object object = value.getValue();
                    int modifiers = value.getModifiers();
                    ScopeNode node = this.builder.createNode(this.path + "." + name, name, object, modifiers, this.depth);
                    if (node == null) continue;
                    this.nodes.add(node);
                }
            }
        }
        return this.nodes;
    }
}

