/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.debug;

import org.snapscript.agent.debug.ScopeExtractor;
import org.snapscript.agent.debug.ScopeVariableTree;
import org.snapscript.agent.event.ScopeEvent;
import org.snapscript.core.trace.TraceType;

public class ScopeEventBuilder {
    private final ScopeVariableTree blank = ScopeVariableTree.EMPTY;
    private final ScopeExtractor extractor;
    private final TraceType type;
    private final String process;
    private final String resource;
    private final String thread;
    private final String stack;
    private final int line;
    private final int depth;
    private final int count;

    public ScopeEventBuilder(ScopeExtractor extractor, TraceType type, String process, String thread, String stack, String resource, int line, int depth, int count) {
        this.extractor = extractor;
        this.process = process;
        this.thread = thread;
        this.resource = resource;
        this.stack = stack;
        this.line = line;
        this.depth = depth;
        this.count = count;
        this.type = type;
    }

    public ScopeEvent suspendEvent() {
        ScopeVariableTree variables = this.extractor.build();
        String name = this.type.name();
        return new ScopeEvent.Builder(this.process).withVariables(variables).withThread(this.thread).withStack(this.stack).withInstruction(name).withStatus("SUSPENDED").withResource(this.resource).withLine(this.line).withDepth(this.depth).withKey(this.count).build();
    }

    public ScopeEvent resumeEvent() {
        String name = this.type.name();
        return new ScopeEvent.Builder(this.process).withVariables(this.blank).withThread(this.thread).withStack(this.stack).withInstruction(name).withStatus("RUNNING").withResource(this.resource).withLine(this.line).withDepth(this.depth).withKey(this.count).build();
    }
}

