/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.debug;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.agent.debug.ScopeBrowser;
import org.snapscript.agent.debug.ScopeNodeEvaluator;
import org.snapscript.agent.debug.ScopeNodeTraverser;
import org.snapscript.agent.debug.ScopeVariableTree;
import org.snapscript.core.Context;
import org.snapscript.core.Scope;

public class ScopeExtractor
implements ScopeBrowser {
    private final AtomicReference<String> evaluate;
    private final ScopeNodeEvaluator evaluator;
    private final ScopeNodeTraverser traverser;
    private final AtomicBoolean execute;
    private final AtomicInteger counter;
    private final Set<String> watch;
    private final Set<String> local;

    public ScopeExtractor(Context context, Scope scope) {
        this.traverser = new ScopeNodeTraverser(context, scope);
        this.evaluator = new ScopeNodeEvaluator(context, scope);
        this.evaluate = new AtomicReference();
        this.watch = new CopyOnWriteArraySet<String>();
        this.local = new CopyOnWriteArraySet<String>();
        this.execute = new AtomicBoolean();
        this.counter = new AtomicInteger();
    }

    public ScopeVariableTree build() {
        boolean refresh = this.execute.getAndSet(false);
        String expression = this.evaluate.get();
        Map<String, Map<String, String>> variables = this.traverser.expand(this.local);
        Map<String, Map<String, String>> evaluation = this.evaluator.expand(this.watch, expression, refresh);
        int change = this.counter.get();
        return new ScopeVariableTree.Builder(change).withLocal(variables).withEvaluation(evaluation).build();
    }

    @Override
    public void browse(Set<String> expand) {
        this.local.clear();
        this.local.addAll(expand);
        this.counter.getAndIncrement();
    }

    @Override
    public void evaluate(Set<String> expand, String expression) {
        this.evaluate(expand, expression, false);
    }

    @Override
    public void evaluate(Set<String> expand, String expression, boolean refresh) {
        this.watch.clear();
        this.watch.addAll(expand);
        this.evaluate.set(expression);
        this.execute.set(refresh);
        this.counter.getAndIncrement();
    }
}

