/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.debug;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.snapscript.agent.debug.ExpressionProcessor;
import org.snapscript.agent.debug.ExpressionScopeNode;
import org.snapscript.agent.debug.ScopeNode;
import org.snapscript.agent.debug.ScopeNodeBuilder;
import org.snapscript.agent.debug.VariableNameEncoder;
import org.snapscript.core.Context;
import org.snapscript.core.Scope;

public class ScopeNodeEvaluator {
    private final ExpressionProcessor processor;
    private final VariableNameEncoder encoder;
    private final Context context;

    public ScopeNodeEvaluator(Context context, Scope scope) {
        this.processor = new ExpressionProcessor(context, scope);
        this.encoder = new VariableNameEncoder();
        this.context = context;
    }

    public Map<String, Map<String, String>> expand(Set<String> expand, String expression, boolean refresh) {
        HashMap<String, Map<String, String>> variables = new HashMap<String, Map<String, String>>();
        ScopeNodeBuilder builder = new ScopeNodeBuilder(variables, this.context);
        ExpressionScopeNode node = new ExpressionScopeNode(builder, this.processor, this.encoder, expression, refresh);
        if (!expand.isEmpty()) {
            for (String path : expand) {
                String[] parts = path.split("\\.");
                this.expand(node, parts, 0);
            }
        } else {
            node.getNodes();
        }
        return variables;
    }

    private void expand(ScopeNode node, String[] parts, int index) {
        List<ScopeNode> children = node.getNodes();
        String match = this.encoder.decode(parts[index]);
        for (ScopeNode child : children) {
            String name = child.getName();
            if (!name.equals(match)) continue;
            this.expand(child, parts, index + 1);
            break;
        }
    }
}

