/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.debug;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.snapscript.agent.debug.ResumeListener;
import org.snapscript.agent.debug.ResumeType;
import org.snapscript.agent.debug.ScopeBrowser;

public class SuspendController {
    private final Map<String, ResumeListener> listeners = new ConcurrentHashMap<String, ResumeListener>();
    private final Map<String, ScopeBrowser> browsers = new ConcurrentHashMap<String, ScopeBrowser>();
    private final Map<String, ResumeType> types = new ConcurrentHashMap<String, ResumeType>();
    private final Map<String, Object> locks = new ConcurrentHashMap<String, Object>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResumeType suspend(ResumeListener listener, ScopeBrowser browser) {
        String name = Thread.currentThread().getName();
        Object lock = this.locks.get(name);
        if (lock == null) {
            lock = new Object();
            this.locks.put(name, lock);
        }
        Object object = lock;
        synchronized (object) {
            try {
                this.browsers.put(name, browser);
                this.listeners.put(name, listener);
                lock.wait();
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not suspend thread '" + name + "'", e);
            }
        }
        return this.types.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(ResumeType type, String thread) {
        Object lock = this.locks.get(thread);
        ResumeListener listener = this.listeners.remove(thread);
        Object object = lock;
        synchronized (object) {
            try {
                this.browsers.remove(thread);
                if (listener != null) {
                    this.types.put(thread, type);
                    listener.resume(thread);
                }
                lock.notify();
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not resume thread '" + thread + "'", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void browse(Set<String> expand, String thread) {
        Object lock = this.locks.get(thread);
        ScopeBrowser browser = this.browsers.get(thread);
        Object object = lock;
        synchronized (object) {
            try {
                if (browser != null) {
                    browser.browse(expand);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not browse thread '" + thread + "'", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(Set<String> expand, String thread, String expression, boolean refresh) {
        Object lock = this.locks.get(thread);
        ScopeBrowser browser = this.browsers.get(thread);
        Object object = lock;
        synchronized (object) {
            try {
                if (browser != null) {
                    browser.evaluate(expand, expression, refresh);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not evaluate '" + expression + "' for thread '" + thread + "'", e);
            }
        }
    }
}

