/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.debug;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.snapscript.core.ModifierType;

public class ValueData {
    public static final String NAME_KEY = "name";
    public static final String TYPE_KEY = "type";
    public static final String VALUE_KEY = "value";
    public static final String DESCRIPTION_KEY = "description";
    public static final String EXPANDABLE_KEY = "expandable";
    public static final String DEPTH_KEY = "depth";
    public static final String MODIFIERS_KEY = "modifiers";
    public static final String PROPERTY_KEY = "property";
    private final String name;
    private final String type;
    private final String value;
    private final String description;
    private final boolean expandable;
    private final int modifiers;
    private final int depth;

    public ValueData(String name, String type, String value, String description, boolean expandable, int modifiers, int depth) {
        this.name = name;
        this.type = type;
        this.value = value;
        this.modifiers = modifiers;
        this.description = description;
        this.expandable = expandable;
        this.depth = depth;
    }

    public Map<String, String> getData() {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put(NAME_KEY, this.name);
        data.put(TYPE_KEY, this.type);
        data.put(VALUE_KEY, this.value);
        data.put(DESCRIPTION_KEY, this.description);
        data.put(MODIFIERS_KEY, this.getModifiers());
        data.put(PROPERTY_KEY, String.valueOf(!ModifierType.isDefault(this.modifiers)));
        data.put(EXPANDABLE_KEY, String.valueOf(this.expandable));
        data.put(DEPTH_KEY, String.valueOf(this.depth));
        return Collections.unmodifiableMap(data);
    }

    private String getModifiers() {
        StringBuilder builder = new StringBuilder();
        if (!ModifierType.isDefault(this.modifiers)) {
            if (ModifierType.isStatic(this.modifiers)) {
                builder.append("[static]");
            }
            if (ModifierType.isPrivate(this.modifiers)) {
                builder.append("[private]");
            }
            if (ModifierType.isProtected(this.modifiers)) {
                builder.append("[protected]");
            }
            if (ModifierType.isPublic(this.modifiers)) {
                builder.append("[public]");
            }
            if (ModifierType.isConstant(this.modifiers)) {
                builder.append("[const]");
            }
            if (ModifierType.isVariable(this.modifiers)) {
                builder.append("[var]");
            }
        }
        return builder.toString();
    }
}

