/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.event;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.snapscript.agent.ProcessMode;
import org.snapscript.agent.event.ExitEvent;
import org.snapscript.agent.event.MessageEnvelope;
import org.snapscript.agent.event.ProcessEventMarshaller;
import org.snapscript.agent.event.ProcessEventType;

public class ExitEventMarshaller
implements ProcessEventMarshaller<ExitEvent> {
    @Override
    public ExitEvent fromMessage(MessageEnvelope message) throws IOException {
        byte[] array = message.getData();
        int length = message.getLength();
        int offset = message.getOffset();
        ByteArrayInputStream buffer = new ByteArrayInputStream(array, offset, length);
        DataInputStream input = new DataInputStream(buffer);
        String process = input.readUTF();
        String type = input.readUTF();
        ProcessMode mode = ProcessMode.resolveMode(type);
        long duration = input.readLong();
        return new ExitEvent.Builder(process).withDuration(duration).withMode(mode).build();
    }

    @Override
    public MessageEnvelope toMessage(ExitEvent value) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(buffer);
        ProcessMode mode = value.getMode();
        String process = value.getProcess();
        String type = mode.name();
        long duration = value.getDuration();
        output.writeUTF(process);
        output.writeUTF(type);
        output.writeLong(duration);
        output.flush();
        byte[] array = buffer.toByteArray();
        return new MessageEnvelope(ProcessEventType.EXIT.code, array, 0, array.length);
    }
}

