/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.event;

import org.snapscript.agent.event.ProcessEvent;

public class PongEvent
implements ProcessEvent {
    private final String project;
    private final String process;
    private final String resource;
    private final String system;
    private final boolean running;

    public PongEvent(Builder builder) {
        this.resource = builder.resource;
        this.process = builder.process;
        this.running = builder.running;
        this.project = builder.project;
        this.system = builder.system;
    }

    @Override
    public String getProcess() {
        return this.process;
    }

    public String getProject() {
        return this.project;
    }

    public String getSystem() {
        return this.system;
    }

    public String getResource() {
        return this.resource;
    }

    public boolean isRunning() {
        return this.running;
    }

    public static class Builder {
        private String project;
        private String process;
        private String resource;
        private String system;
        private boolean running;

        public Builder(String process) {
            this.process = process;
        }

        public Builder withProject(String project) {
            this.project = project;
            return this;
        }

        public Builder withProcess(String process) {
            this.process = process;
            return this;
        }

        public Builder withResource(String resource) {
            this.resource = resource;
            return this;
        }

        public Builder withSystem(String system) {
            this.system = system;
            return this;
        }

        public Builder withRunning(boolean running) {
            this.running = running;
            return this;
        }

        public PongEvent build() {
            return new PongEvent(this);
        }
    }
}

