/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.event;

import java.io.Closeable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.snapscript.agent.event.MessageEnvelope;
import org.snapscript.agent.event.MessageEnvelopeReader;
import org.snapscript.agent.event.ProcessEvent;
import org.snapscript.agent.event.ProcessEventMarshaller;
import org.snapscript.agent.event.ProcessEventType;

public class ProcessEventConsumer {
    private final Map<Integer, ProcessEventMarshaller> marshallers = new HashMap<Integer, ProcessEventMarshaller>();
    private final MessageEnvelopeReader reader;

    public ProcessEventConsumer(InputStream stream, Closeable closeable) {
        this.reader = new MessageEnvelopeReader(stream, closeable);
    }

    public ProcessEvent consume() throws Exception {
        MessageEnvelope message;
        int code;
        ProcessEventMarshaller marshaller;
        if (this.marshallers.isEmpty()) {
            ProcessEventType[] events;
            for (ProcessEventType event : events = ProcessEventType.values()) {
                ProcessEventMarshaller marshaller2 = event.marshaller.newInstance();
                this.marshallers.put(event.code, marshaller2);
            }
        }
        if ((marshaller = this.marshallers.get(code = (message = this.reader.read()).getCode())) == null) {
            throw new IllegalStateException("Could not find marshaller for " + code);
        }
        return marshaller.fromMessage(message);
    }
}

