/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.event;

import java.util.Collections;
import java.util.Set;
import org.snapscript.agent.event.ProcessEvent;
import org.snapscript.agent.profiler.ProfileResult;

public class ProfileEvent
implements ProcessEvent {
    private final Set<ProfileResult> results;
    private final String process;

    private ProfileEvent(Builder builder) {
        this.results = Collections.unmodifiableSet(builder.results);
        this.process = builder.process;
    }

    @Override
    public String getProcess() {
        return this.process;
    }

    public Set<ProfileResult> getResults() {
        return this.results;
    }

    public static class Builder {
        private Set<ProfileResult> results;
        private String process;

        public Builder(String process) {
            this.process = process;
        }

        public Builder withResults(Set<ProfileResult> results) {
            this.results = results;
            return this;
        }

        public Builder withProcess(String process) {
            this.process = process;
            return this;
        }

        public ProfileEvent build() {
            return new ProfileEvent(this);
        }
    }
}

