/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.event;

import org.snapscript.agent.event.ProcessEvent;

public class SyntaxErrorEvent
implements ProcessEvent {
    private final String description;
    private final String resource;
    private final String process;
    private final int line;

    private SyntaxErrorEvent(Builder builder) {
        this.description = builder.description;
        this.process = builder.process;
        this.resource = builder.resource;
        this.line = builder.line;
    }

    @Override
    public String getProcess() {
        return this.process;
    }

    public String getDescription() {
        return this.description;
    }

    public String getResource() {
        return this.resource;
    }

    public int getLine() {
        return this.line;
    }

    public static class Builder {
        private String description;
        private String resource;
        private String process;
        private int line;

        public Builder(String process) {
            this.process = process;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withResource(String resource) {
            this.resource = resource;
            return this;
        }

        public Builder withProcess(String process) {
            this.process = process;
            return this;
        }

        public Builder withLine(int line) {
            this.line = line;
            return this;
        }

        public SyntaxErrorEvent build() {
            return new SyntaxErrorEvent(this);
        }
    }
}

