/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.event.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.snapscript.agent.event.BeginEvent;
import org.snapscript.agent.event.BreakpointsEvent;
import org.snapscript.agent.event.BrowseEvent;
import org.snapscript.agent.event.EvaluateEvent;
import org.snapscript.agent.event.ExecuteEvent;
import org.snapscript.agent.event.ExitEvent;
import org.snapscript.agent.event.FaultEvent;
import org.snapscript.agent.event.PingEvent;
import org.snapscript.agent.event.PongEvent;
import org.snapscript.agent.event.ProcessEvent;
import org.snapscript.agent.event.ProcessEventChannel;
import org.snapscript.agent.event.ProcessEventConnection;
import org.snapscript.agent.event.ProcessEventConsumer;
import org.snapscript.agent.event.ProcessEventExecutor;
import org.snapscript.agent.event.ProcessEventListener;
import org.snapscript.agent.event.ProcessEventProducer;
import org.snapscript.agent.event.ProfileEvent;
import org.snapscript.agent.event.RegisterEvent;
import org.snapscript.agent.event.ScopeEvent;
import org.snapscript.agent.event.StepEvent;
import org.snapscript.agent.event.SyntaxErrorEvent;
import org.snapscript.agent.event.WriteErrorEvent;
import org.snapscript.agent.event.WriteOutputEvent;
import org.snapscript.agent.event.client.ProcessEventTunnel;
import org.snapscript.agent.log.ProcessLogger;

public class ProcessEventClient {
    private final ProcessEventListener listener;
    private final ProcessEventExecutor executor = new ProcessEventExecutor();
    private final ProcessLogger logger;

    public ProcessEventClient(ProcessEventListener listener, ProcessLogger logger) throws IOException {
        this.listener = listener;
        this.logger = logger;
    }

    public ProcessEventChannel connect(String host, int port) throws Exception {
        try {
            Socket socket = new Socket(host, port);
            ProcessEventTunnel tunnel = new ProcessEventTunnel(this.logger, port);
            InputStream input = socket.getInputStream();
            OutputStream output = socket.getOutputStream();
            SocketConnection connection = new SocketConnection(socket, input, output);
            tunnel.tunnel(socket);
            socket.setSoTimeout(10000);
            connection.start();
            return connection;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not connect to " + host + ":" + port, e);
        }
    }

    private class SocketConnection
    extends Thread
    implements ProcessEventChannel {
        private final ProcessEventConnection connection;
        private final AtomicBoolean open;
        private final Socket socket;

        public SocketConnection(Socket socket, InputStream input, OutputStream output) throws IOException {
            this.connection = new ProcessEventConnection(ProcessEventClient.this.logger, ProcessEventClient.this.executor, input, output, socket);
            this.open = new AtomicBoolean(true);
            this.socket = socket;
        }

        @Override
        public boolean send(ProcessEvent event) throws Exception {
            ProcessEventProducer producer = this.connection.getProducer();
            String process = event.getProcess();
            try {
                producer.produce(event);
                return true;
            }
            catch (Exception e) {
                ProcessEventClient.this.logger.info(process + ": Error sending event", e);
                this.close(process + ": Error sending event " + event + ": " + e);
                return false;
            }
        }

        @Override
        public boolean sendAsync(ProcessEvent event) throws Exception {
            ProcessEventProducer producer = this.connection.getProducer();
            String process = event.getProcess();
            try {
                Future<Boolean> future = producer.produceAsync(event);
                return future.get();
            }
            catch (Exception e) {
                ProcessEventClient.this.logger.info(process + ": Error sending async event", e);
                this.close(process + ": Error sending async event " + event + ": " + e);
                return false;
            }
        }

        @Override
        public void run() {
            try {
                try {
                    ProcessEventConsumer consumer = this.connection.getConsumer();
                    while (true) {
                        ProcessEvent event;
                        if ((event = consumer.consume()) instanceof ExitEvent) {
                            ProcessEventClient.this.listener.onExit(this, (ExitEvent)event);
                            continue;
                        }
                        if (event instanceof ExecuteEvent) {
                            ProcessEventClient.this.listener.onExecute(this, (ExecuteEvent)event);
                            continue;
                        }
                        if (event instanceof RegisterEvent) {
                            ProcessEventClient.this.listener.onRegister(this, (RegisterEvent)event);
                            continue;
                        }
                        if (event instanceof SyntaxErrorEvent) {
                            ProcessEventClient.this.listener.onSyntaxError(this, (SyntaxErrorEvent)event);
                            continue;
                        }
                        if (event instanceof WriteErrorEvent) {
                            ProcessEventClient.this.listener.onWriteError(this, (WriteErrorEvent)event);
                            continue;
                        }
                        if (event instanceof WriteOutputEvent) {
                            ProcessEventClient.this.listener.onWriteOutput(this, (WriteOutputEvent)event);
                            continue;
                        }
                        if (event instanceof PingEvent) {
                            ProcessEventClient.this.listener.onPing(this, (PingEvent)event);
                            continue;
                        }
                        if (event instanceof PongEvent) {
                            ProcessEventClient.this.listener.onPong(this, (PongEvent)event);
                            continue;
                        }
                        if (event instanceof ScopeEvent) {
                            ProcessEventClient.this.listener.onScope(this, (ScopeEvent)event);
                            continue;
                        }
                        if (event instanceof BreakpointsEvent) {
                            ProcessEventClient.this.listener.onBreakpoints(this, (BreakpointsEvent)event);
                            continue;
                        }
                        if (event instanceof BeginEvent) {
                            ProcessEventClient.this.listener.onBegin(this, (BeginEvent)event);
                            continue;
                        }
                        if (event instanceof StepEvent) {
                            ProcessEventClient.this.listener.onStep(this, (StepEvent)event);
                            continue;
                        }
                        if (event instanceof BrowseEvent) {
                            ProcessEventClient.this.listener.onBrowse(this, (BrowseEvent)event);
                            continue;
                        }
                        if (event instanceof EvaluateEvent) {
                            ProcessEventClient.this.listener.onEvaluate(this, (EvaluateEvent)event);
                            continue;
                        }
                        if (event instanceof ProfileEvent) {
                            ProcessEventClient.this.listener.onProfile(this, (ProfileEvent)event);
                            continue;
                        }
                        if (!(event instanceof FaultEvent)) continue;
                        ProcessEventClient.this.listener.onFault(this, (FaultEvent)event);
                    }
                }
                catch (Exception e) {
                    ProcessEventClient.this.logger.info("Error processing events", e);
                    this.close("Error in event loop: " + e);
                    this.close("Event loop has finished");
                }
            }
            catch (Throwable throwable) {
                this.close("Event loop has finished");
                throw throwable;
            }
        }

        @Override
        public void close(String reason) {
            try {
                ProcessEventProducer producer = this.connection.getProducer();
                if (this.open.compareAndSet(true, false)) {
                    ProcessEventClient.this.listener.onClose(this);
                    producer.close(reason);
                }
                this.socket.close();
            }
            catch (Exception e) {
                ProcessEventClient.this.logger.info("Error closing client connection", e);
            }
        }
    }
}

