/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.log;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.agent.log.ConsoleLog;
import org.snapscript.agent.log.FileLogAppender;
import org.snapscript.agent.log.FileLogCompressor;
import org.snapscript.agent.log.FileLogRoller;
import org.snapscript.agent.log.ProcessLog;

public class FileLog
implements ProcessLog {
    private final FileLogCompressor compressor;
    private final FileLogAppender appender;
    private final FileLogRoller roller;
    private final AtomicInteger counter;
    private final ConsoleLog logger;
    private final File file;
    private final int lines;

    public FileLog(File file) {
        this(file, true);
    }

    public FileLog(File file, boolean append) {
        this(file, append, 20000);
    }

    public FileLog(File file, boolean append, int lines) {
        this.counter = new AtomicInteger(lines > 0 ? lines : 1000);
        this.appender = new FileLogAppender(file, append);
        this.roller = new FileLogRoller();
        this.compressor = new FileLogCompressor(this.roller);
        this.logger = new ConsoleLog();
        this.lines = lines;
        this.file = file;
    }

    @Override
    public void log(Object text) {
        this.log(text, null);
    }

    @Override
    public void log(Object text, Throwable cause) {
        try {
            File normal = this.file.getCanonicalFile();
            File parent = normal.getParentFile();
            int count = this.counter.getAndDecrement();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            if (count == this.lines) {
                this.compressor.compressFiles(parent);
            }
            if (count <= 0) {
                this.counter.set(this.lines > 0 ? this.lines : 1000);
                this.appender.close();
                this.roller.rollFile(this.file);
                this.compressor.compressFiles(parent);
            }
            this.logger.log(text, cause);
            this.appender.append(text, cause);
        }
        catch (Exception e) {
            this.logger.log("Could not append to " + this.file, e);
            this.appender.close();
        }
    }
}

