/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.log;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;

public class FileLogAppender {
    private FileWriter appender;
    private PrintWriter writer;
    private File file;
    private boolean append;

    public FileLogAppender(File file) {
        this(file, true);
    }

    public FileLogAppender(File file, boolean append) {
        this.append = append;
        this.file = file;
    }

    public void append(Object text) {
        this.append(text, null);
    }

    public void append(Object text, Throwable cause) {
        try {
            if (!this.file.exists() || this.writer == null || this.writer.checkError()) {
                this.appender = new FileWriter(this.file, this.append);
                this.writer = new PrintWriter(this.appender);
            }
            this.writer.print(text);
            if (cause != null) {
                this.writer.print(": ");
                cause.printStackTrace(this.writer);
            } else {
                this.writer.println();
            }
            this.writer.flush();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not write to file '" + this.file + "'", e);
        }
    }

    public void close() {
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not close file '" + this.file + "'", e);
        }
    }
}

