/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.log;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.snapscript.agent.log.ProcessLog;
import org.snapscript.common.thread.ThreadBuilder;

public class ProcessLogger {
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final int EVENT_LIMIT = 10000;
    private final LogDispatcher dispatcher = new LogDispatcher(10000);
    private final DateFormatter formatter = new DateFormatter("HH:mm:ss");
    private final ProcessLog logger;
    private final LogLevel level;

    public ProcessLogger(ProcessLog logger) {
        this(logger, null);
    }

    public ProcessLogger(ProcessLog logger, String level) {
        this.level = LogLevel.resolveLevel(level);
        this.logger = logger;
    }

    public String getLevel() {
        return this.level.name();
    }

    public boolean isTrace() {
        return this.level.isTrace();
    }

    public boolean isDebug() {
        return this.level.isDebug();
    }

    public void trace(String message) {
        if (this.level.isTrace()) {
            this.log(message);
        }
    }

    public void trace(String message, Throwable cause) {
        if (this.level.isTrace()) {
            this.log(message, cause);
        }
    }

    public void debug(String message) {
        if (this.level.isDebug()) {
            this.log(message);
        }
    }

    public void debug(String message, Throwable cause) {
        if (this.level.isDebug()) {
            this.log(message, cause);
        }
    }

    public void info(String message) {
        if (this.level.isInfo()) {
            this.log(message);
        }
    }

    public void info(String message, Throwable cause) {
        if (this.level.isInfo()) {
            this.log(message, cause);
        }
    }

    private void log(String message) {
        LogEvent event = new LogEvent(message, null);
        this.dispatcher.log(event);
    }

    private void log(String message, Throwable cause) {
        LogEvent event = new LogEvent(message, cause);
        this.dispatcher.log(event);
    }

    private class LogEvent
    implements Runnable {
        private final Throwable cause;
        private final String message;
        private final Thread thread;
        private final long time = System.currentTimeMillis();

        public LogEvent(String message, Throwable cause) {
            this.thread = Thread.currentThread();
            this.message = message;
            this.cause = cause;
        }

        @Override
        public void run() {
            String name = this.thread.getName();
            DateFormat format = (DateFormat)ProcessLogger.this.formatter.get();
            String date = format.format(this.time);
            if (this.message != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(date);
                builder.append(" [");
                builder.append(name);
                builder.append("] ");
                builder.append(this.message);
                if (this.cause != null) {
                    if (ProcessLogger.this.level.isTrace()) {
                        ProcessLogger.this.logger.log(builder, this.cause);
                    } else {
                        builder.append(": ");
                        builder.append(this.cause);
                        ProcessLogger.this.logger.log(builder);
                    }
                } else {
                    ProcessLogger.this.logger.log(builder);
                }
            }
        }
    }

    private class LogDispatcher
    implements Runnable {
        private final BlockingQueue<LogEvent> queue;
        private final ThreadFactory factory = new ThreadBuilder();
        private final AtomicBoolean active;

        public LogDispatcher(int capacity) {
            this.queue = new ArrayBlockingQueue<LogEvent>(capacity);
            this.active = new AtomicBoolean(false);
        }

        public void log(LogEvent event) {
            try {
                if (this.active.compareAndSet(false, true)) {
                    Thread thread = this.factory.newThread(this);
                    thread.start();
                }
                this.queue.offer(event, 10000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not log event", e);
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static enum LogLevel {
        TRACE(0),
        DEBUG(1),
        INFO(2);

        private final int level;

        private LogLevel(int level) {
            this.level = level;
        }

        public boolean isTrace() {
            return this.level <= LogLevel.TRACE.level;
        }

        public boolean isDebug() {
            return this.level <= LogLevel.DEBUG.level;
        }

        public boolean isInfo() {
            return this.level <= LogLevel.INFO.level;
        }

        public static LogLevel resolveLevel(String token) {
            if (token != null) {
                LogLevel[] levels;
                String match = token.trim();
                for (LogLevel level : levels = LogLevel.values()) {
                    String name = level.name();
                    if (!name.equalsIgnoreCase(match)) continue;
                    return level;
                }
            }
            return INFO;
        }
    }

    private class DateFormatter
    extends ThreadLocal<DateFormat> {
        private final String format;

        public DateFormatter(String format) {
            this.format = format;
        }

        @Override
        public DateFormat initialValue() {
            return new SimpleDateFormat(this.format);
        }
    }
}

