/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.agent.profiler;

import java.util.SortedSet;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.agent.event.ProcessEventChannel;
import org.snapscript.agent.event.ProfileEvent;
import org.snapscript.agent.profiler.ProcessProfiler;
import org.snapscript.agent.profiler.ProfileResult;
import org.snapscript.common.thread.ThreadBuilder;

public class ProfileResultUpdater
implements Runnable {
    private final AtomicReference<String> reference = new AtomicReference();
    private final ProcessEventChannel channel;
    private final ProcessProfiler profiler;
    private final ThreadFactory factory = new ThreadBuilder();

    public ProfileResultUpdater(ProcessProfiler profiler, ProcessEventChannel channel) {
        this.profiler = profiler;
        this.channel = channel;
    }

    public void start(String process) {
        if (this.reference.compareAndSet(null, process)) {
            Thread thread = this.factory.newThread(this);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long delay = 1000L;
        while (true) {
            String process = this.reference.get();
            try {
                Thread.sleep(delay);
                SortedSet<ProfileResult> results = this.profiler.lines(2000);
                ProfileEvent event = new ProfileEvent.Builder(process).withResults(results).build();
                this.channel.send(event);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            finally {
                delay = 5000L;
                continue;
            }
            break;
        }
    }
}

